/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.yaml;

import com.newrelic.agent.Agent;
import com.newrelic.agent.TracerFactoryException;
import com.newrelic.agent.extension.ConfigurationConstruct;
import com.newrelic.agent.instrumentation.DefaultPointCut;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.OrClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.InvalidMethodDescriptor;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.NoMethodsMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.OrMethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.ClassMethodNameFormatPointCut;
import com.newrelic.agent.instrumentation.yaml.CustomTracerFactory;
import com.newrelic.agent.instrumentation.yaml.InstrumentationConstructor;
import com.newrelic.agent.instrumentation.yaml.MetricNameFormatFactory;
import com.newrelic.agent.instrumentation.yaml.TracerFactoryConfiguration;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.TracerFactory;
import com.newrelic.agent.tracers.metricname.ClassMethodMetricNameFormat;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;
import com.newrelic.agent.util.Strings;
import com.newrelic.api.agent.MethodTracerFactory;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointCutFactory {
    private final String defaultMetricPrefix;
    private final ClassLoader classLoader;

    public PointCutFactory(ClassLoader classLoader, String metricPrefix) {
        this.classLoader = classLoader;
        this.defaultMetricPrefix = metricPrefix;
    }

    public Collection<PointCut> getPointCuts(Object config) throws ParseException {
        if (config instanceof List) {
            return this.getPointCuts((List)config);
        }
        if (config instanceof Map) {
            return this.getPointCuts((Map)config);
        }
        return Collections.EMPTY_LIST;
    }

    public PointCut getPointCut(Object obj) throws ParseException {
        if (obj instanceof String) {
            return this.getPointCut((String)obj);
        }
        if (obj instanceof Map) {
            return this.getPointCut((Map)obj);
        }
        throw new RuntimeException(MessageFormat.format("Unknown pointcut type: {0} ({1}", obj, obj.getClass().getName()));
    }

    public PointCut getPointCut(String string) throws ParseException {
        ClassMethodSignature sig = PointCutFactory.parseClassMethodSignature(string);
        if (sig != null) {
            ClassMethodNameFormatDescriptor format = new ClassMethodNameFormatDescriptor(this.defaultMetricPrefix, false);
            return new ClassMethodNameFormatPointCut(format, new ExactClassMatcher(sig.getClassName()), PointCutFactory.createExactMethodMatcher(sig.getMethodName(), sig.getMethodDesc()), false, Collections.emptyMap());
        }
        throw new RuntimeException("Unable to parse point cut: " + string);
    }

    private PointCut getPointCut(Map attrs) {
        ClassMatcher classMatcher = PointCutFactory.getClassMatcher(attrs.get("class_matcher"));
        if (classMatcher == null) {
            throw new RuntimeException("No class matcher for " + attrs.toString());
        }
        MethodMatcher methodMatcher = PointCutFactory.getMethodMatcher(attrs.get("method_matcher"));
        if (methodMatcher == null) {
            throw new RuntimeException("No method matcher for " + attrs.toString());
        }
        TracerFactoryConfiguration config = new TracerFactoryConfiguration(this.defaultMetricPrefix, attrs);
        Object tracerFactoryName = attrs.get("tracer_factory");
        if (tracerFactoryName != null) {
            try {
                TracerFactory tracerFactory = this.getTracerFactory(tracerFactoryName.toString(), config);
                return new DefaultPointCut(new PointCutConfiguration((String)null), tracerFactory, classMatcher, methodMatcher);
            }
            catch (TracerFactoryException ex) {
                throw new RuntimeException("Unable to create tracer factory " + tracerFactoryName, ex);
            }
        }
        return new ClassMethodNameFormatPointCut(config.getMetricNameFormatFactory(), classMatcher, methodMatcher, config.isDispatcher(), attrs);
    }

    private TracerFactory instantiateTracerFactory(Class<? extends TracerFactory> clazz, TracerFactoryConfiguration config) throws TracerFactoryException {
        try {
            return clazz.getConstructor(TracerFactoryConfiguration.class).newInstance(config);
        }
        catch (Exception e) {
            try {
                return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e2) {
                throw new TracerFactoryException("Unable to instantiate tracer factory " + clazz.getName(), e2);
            }
        }
    }

    public TracerFactory getTracerFactory(String tracerFactoryName, TracerFactoryConfiguration config) throws TracerFactoryException {
        try {
            Class<?> clazz = this.classLoader.loadClass(tracerFactoryName);
            String msg = MessageFormat.format("Instantiating custom tracer factory {0}", tracerFactoryName);
            Agent.LOG.finest(msg);
            if (TracerFactory.class.isAssignableFrom(clazz)) {
                return this.instantiateTracerFactory(clazz, config);
            }
            if (MethodTracerFactory.class.isAssignableFrom(clazz)) {
                return this.instantiateMethodTracerFactory(clazz);
            }
            throw new TracerFactoryException("Unknown tracer factory type:" + tracerFactoryName);
        }
        catch (Exception ex) {
            throw new TracerFactoryException("Unable to load tracer factory " + tracerFactoryName, ex);
        }
    }

    private TracerFactory instantiateMethodTracerFactory(Class clazz) throws Exception {
        MethodTracerFactory factory = (MethodTracerFactory)clazz.newInstance();
        return new CustomTracerFactory(factory);
    }

    public List<PointCut> getPointCuts(List list) throws ParseException {
        ArrayList<PointCut> pcs = new ArrayList<PointCut>();
        for (Object obj : list) {
            pcs.add(this.getPointCut(obj));
        }
        return pcs;
    }

    public List<PointCut> getPointCuts(Map namesToPointCuts) throws ParseException {
        Collection values = null;
        if (null != namesToPointCuts) {
            values = namesToPointCuts.values();
        }
        if (null == values) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<PointCut> pcs = new ArrayList<PointCut>();
        for (Object obj : values) {
            if (obj instanceof String) {
                pcs.add(this.getPointCut((String)obj));
                continue;
            }
            if (!(obj instanceof Map)) continue;
            pcs.add(this.getPointCut((Map)obj));
        }
        return pcs;
    }

    static Collection<ClassMatcher> getClassMatchers(Collection matchers) {
        ArrayList<ClassMatcher> list = new ArrayList<ClassMatcher>(matchers.size());
        for (Object matcher : matchers) {
            list.add(PointCutFactory.getClassMatcher(matcher));
        }
        return list;
    }

    static ClassMatcher getClassMatcher(Object yaml) {
        if (yaml instanceof ClassMatcher) {
            return (ClassMatcher)yaml;
        }
        if (yaml instanceof String) {
            return new ExactClassMatcher(((String)yaml).trim());
        }
        if (yaml instanceof List) {
            List list = (List)yaml;
            return OrClassMatcher.getClassMatcher(PointCutFactory.getClassMatchers(list));
        }
        return null;
    }

    static Collection<MethodMatcher> getMethodMatchers(Collection matchers) {
        ArrayList<MethodMatcher> list = new ArrayList<MethodMatcher>(matchers.size());
        for (Object matcher : matchers) {
            list.add(PointCutFactory.getMethodMatcher(matcher));
        }
        return list;
    }

    static MethodMatcher getMethodMatcher(Object yaml) {
        MethodMatcher matcher = null;
        if (yaml instanceof MethodMatcher) {
            matcher = (MethodMatcher)yaml;
        } else {
            if (yaml instanceof List) {
                List list = (List)yaml;
                if (!list.isEmpty() && list.get(0) instanceof String && list.get(0).toString().indexOf(40) < 0) {
                    return PointCutFactory.createExactMethodMatcher(list.get(0).toString().trim(), Strings.trim(list.subList(1, list.size())));
                }
                return OrMethodMatcher.getMethodMatcher(PointCutFactory.getMethodMatchers(list));
            }
            if (yaml instanceof String) {
                String text = yaml.toString().trim();
                int index = text.indexOf(40);
                if (index > 0) {
                    String methodName = text.substring(0, index);
                    String methodDesc = text.substring(index);
                    return PointCutFactory.createExactMethodMatcher(methodName, methodDesc);
                }
                return new ExactMethodMatcher(text, new String[0]);
            }
        }
        return matcher;
    }

    public static ClassMethodSignature parseClassMethodSignature(String signature) {
        int methodArgIndex = signature.indexOf(40);
        if (methodArgIndex > 0) {
            String methodDesc = signature.substring(methodArgIndex);
            String classAndMethod = signature.substring(0, methodArgIndex);
            int methodStart = classAndMethod.lastIndexOf(46);
            if (methodStart > 0) {
                String methodName = classAndMethod.substring(methodStart + 1);
                String className = classAndMethod.substring(0, methodStart);
                return new ClassMethodSignature(className, methodName, methodDesc);
            }
        }
        return null;
    }

    public static MethodMatcher createExactMethodMatcher(String methodName, String methodDesc) {
        ExactMethodMatcher methodMatcher = new ExactMethodMatcher(methodName, methodDesc);
        return PointCutFactory.validateMethodMatcher(methodMatcher);
    }

    public static MethodMatcher createExactMethodMatcher(String methodName, Collection<String> methodDescriptions) {
        ExactMethodMatcher methodMatcher = new ExactMethodMatcher(methodName, methodDescriptions);
        return PointCutFactory.validateMethodMatcher(methodMatcher);
    }

    private static MethodMatcher validateMethodMatcher(ExactMethodMatcher methodMatcher) {
        try {
            methodMatcher.validate();
            return methodMatcher;
        }
        catch (InvalidMethodDescriptor e) {
            Agent.LOG.log(Level.SEVERE, e.toString());
            Agent.LOG.log(Level.FINER, "Error creating method matcher", e);
            return new NoMethodsMatcher();
        }
    }

    public static Collection<ConfigurationConstruct> getConstructs() {
        return new InstrumentationConstructor().constructs;
    }

    public static class ClassMethodNameFormatDescriptor
    implements MetricNameFormatFactory {
        private final String prefix;

        public ClassMethodNameFormatDescriptor(String prefix, boolean dispatcher) {
            this.prefix = ClassMethodNameFormatDescriptor.getMetricPrefix(prefix, dispatcher);
        }

        public MetricNameFormat getMetricNameFormat(ClassMethodSignature sig, Object object, Object[] args) {
            if (Strings.isEmpty(this.prefix)) {
                return new ClassMethodMetricNameFormat(sig, object);
            }
            return new ClassMethodMetricNameFormat(sig, object, this.prefix);
        }

        private static String getMetricPrefix(String prefix, boolean dispatcher) {
            if (dispatcher) {
                if (prefix.startsWith("OtherTransaction")) {
                    return prefix;
                }
                return "OtherTransaction/" + prefix;
            }
            return prefix;
        }
    }
}

