/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.logging;

import com.newrelic.agent.config.IAgentConfig;
import com.newrelic.agent.logging.AgentLogger;
import com.newrelic.agent.logging.IAgentLogManager;
import com.newrelic.agent.logging.IAgentLogger;
import com.newrelic.agent.logging.Log4jLogManager;

public class AgentLogManager {
    private static final String ROOT_LOGGER_NAME = "com.newrelic.agent";
    private static final String NEW_RELIC_USE_JAVA_LOGGING = "newrelic.use_java_logging";
    private static final IAgentLogManager INSTANCE = AgentLogManager.createAgentLogManager();
    private static final IAgentLogger ROOT_LOGGER = INSTANCE.getRootLogger();

    private AgentLogManager() {
    }

    private static IAgentLogManager createAgentLogManager() {
        if (Boolean.getBoolean(NEW_RELIC_USE_JAVA_LOGGING)) {
            return AgentLogger.create(ROOT_LOGGER_NAME);
        }
        return Log4jLogManager.create(ROOT_LOGGER_NAME);
    }

    public static IAgentLogger getLogger() {
        return ROOT_LOGGER;
    }

    public static String getLogFilePath() {
        return INSTANCE.getLogFilePath();
    }

    public static void configureLogger(IAgentConfig agentConfig) {
        INSTANCE.configureLogger(agentConfig);
    }

    public static void addConsoleHandler() {
        INSTANCE.addConsoleHandler();
    }

    public static void setLogLevel(String level) {
        INSTANCE.setLogLevel(level);
    }

    public static String getLogLevel() {
        return INSTANCE.getLogLevel();
    }
}

