/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.logging;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.Config2;
import com.newrelic.agent.config.IAgentConfig;
import com.newrelic.agent.logging.IAgentLogManager;
import com.newrelic.agent.logging.IAgentLogger;
import com.newrelic.agent.logging.LogFileHelper;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.XMLFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AgentLogger
extends Logger
implements IAgentLogger,
IAgentLogManager {
    private static final String SIMPLE_LOG_FORMAT = "simple";
    private static final Map<String, Level> LEVEL_MAP = new HashMap<String, Level>();
    private final Map<String, SimpleLogger> childLoggers = new HashMap<String, SimpleLogger>();
    private volatile String logFilePath;
    private volatile IAgentConfig agentConfig;

    private AgentLogger(String name) {
        super(name, null);
    }

    public static AgentLogger create(String name) {
        return new AgentLogger(name);
    }

    @Override
    public IAgentLogger getRootLogger() {
        return this;
    }

    @Override
    public void addConsoleHandler() {
        this.addHandler(new ConsoleHandler());
    }

    @Override
    public void setLogLevel(String level) {
        Level logLevel = LEVEL_MAP.get(level.toLowerCase());
        this.setLevel(logLevel);
    }

    @Override
    public void error(String s) {
        this.warning(s);
    }

    @Override
    public void debug(String s) {
        this.finer(s);
    }

    @Override
    public void trace(String s) {
        this.finest(s);
    }

    @Override
    public boolean isFineEnabled() {
        return this.isLoggable(Level.FINE);
    }

    @Override
    public boolean isFinerEnabled() {
        return this.isLoggable(Level.FINER);
    }

    @Override
    public boolean isFinestEnabled() {
        return this.isLoggable(Level.FINEST);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isLoggable(Level.FINER);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isLoggable(Level.FINEST);
    }

    @Override
    public void configureLogger(IAgentConfig agentConfig) {
        this.agentConfig = agentConfig;
        boolean debug = agentConfig.isDebugEnabled();
        boolean isLoggingToStdOut = agentConfig.isLoggingToStdOut();
        File logFile = LogFileHelper.getLogFile(agentConfig);
        String logFileName = null;
        this.setUseParentHandlers(false);
        if (isLoggingToStdOut) {
            Level logLevel = this.getLogLevel(agentConfig.getLogLevel());
            if (debug) {
                logLevel = Level.FINEST;
            }
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setLevel(logLevel);
            this.addHandler(consoleHandler);
            this.setLevel(logLevel);
        } else if (debug) {
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setLevel(Level.FINEST);
            this.addHandler(consoleHandler);
            this.setLevel(Level.FINEST);
        } else {
            this.setLevel(this.getLogLevel(agentConfig.getLogLevel()));
        }
        this.configureChildLoggers();
        if (logFile != null) {
            try {
                logFileName = logFile.getPath();
                int limit = agentConfig.getProperty("log_limit_in_kbytes", 0) * 1024;
                int fileCount = Math.max(1, agentConfig.getProperty("log_file_count", 1));
                this.addHandler(new FileHandler(logFileName, limit, fileCount, true));
            }
            catch (IOException ex) {
                if (!debug) {
                    this.addHandler(new ConsoleHandler());
                }
                String msg = MessageFormat.format("Unable to configure newrelic log file : {0}", logFile);
                Agent.LOG.warning(msg);
            }
        }
        this.setFormatter((Config2)((Object)agentConfig), this);
        if (logFileName != null) {
            this.log(Level.INFO, "Writing to New Relic log file : {0}", logFileName);
        }
        if (debug) {
            this.config("Agent debug logging on");
        }
        if (isLoggingToStdOut) {
            this.config("Agent is logging to standard out");
        }
        this.logFilePath = logFileName;
    }

    private Level getLogLevel(String logLevel) {
        if (logLevel == null) {
            return Level.INFO;
        }
        Level level = LEVEL_MAP.get(logLevel);
        return level == null ? Level.INFO : level;
    }

    @Override
    public String getLogLevel() {
        return this.getLevel().getName();
    }

    @Override
    public IAgentLogger getChildLogger(Class<?> clazz) {
        return this.getChildLogger(clazz.getName(), clazz.getSimpleName());
    }

    @Override
    public synchronized IAgentLogger getChildLogger(String fullName, String simpleName) {
        Object config;
        Object loggersConfig;
        SimpleLogger logger = new SimpleLogger(fullName, null);
        this.childLoggers.put(simpleName, logger);
        boolean configure = true;
        if (this.agentConfig != null && (loggersConfig = this.agentConfig.getProperty("loggers")) instanceof Map && (config = ((Map)loggersConfig).get(simpleName)) instanceof Map) {
            this.configureLogger(logger, new Config2((Map)config, null));
            configure = false;
        }
        if (configure) {
            Map<String, Object> emptyMap = Collections.emptyMap();
            this.configureLogger(logger, new Config2(emptyMap, null));
        }
        return logger;
    }

    @Override
    public String getLogFilePath() {
        return this.logFilePath;
    }

    private void configureLogger(SimpleLogger logger, Config2 config) {
        Object logLevel = config.getProperty("log_level");
        if (logLevel != null) {
            logger.setLevel(this.getLogLevel(logLevel.toString()));
        }
        boolean useParent = config.getProperty("use_parent", true);
        logger.setUseParentHandlers(useParent);
        logger.setParent(this);
        Object fileName = config.getProperty("file_name");
        if (fileName != null) {
            File logFile = LogFileHelper.getLogFile(this.agentConfig);
            logFile = new File(logFile.getParentFile(), fileName.toString());
            try {
                FileHandler handler = new FileHandler(logFile.getPath());
                logger.addHandler(handler);
                handler.setFormatter(this.getFormatter((Config2)((Object)this.agentConfig)));
            }
            catch (Exception e) {
                String msg = MessageFormat.format("Error initializing logger : {0}", e.toString());
                this.severe(msg);
            }
        }
        try {
            this.setFormatter(config, logger);
        }
        catch (Exception e) {
            Agent.LOG.fine(MessageFormat.format("Unable to set child logger format : {0}", e.toString()));
        }
    }

    private void configureChildLoggers() {
        Object loggersConfig = this.agentConfig.getProperty("loggers");
        if (loggersConfig instanceof Map) {
            Set entries = ((Map)loggersConfig).entrySet();
            for (Map.Entry entry : entries) {
                SimpleLogger logger = this.childLoggers.get(entry.getKey());
                if (logger == null || !(entry.getValue() instanceof Map)) continue;
                this.configureLogger(logger, new Config2((Map)entry.getValue(), null));
            }
        }
    }

    private Formatter getFormatter(Config2 config) {
        String format = config.getProperty("log_format", SIMPLE_LOG_FORMAT);
        if (SIMPLE_LOG_FORMAT.equals(format)) {
            return new LogFormatter();
        }
        if ("xml".equals(format)) {
            return new XMLFormatter();
        }
        return new SimpleFormatter();
    }

    private void setFormatter(Config2 config, Logger agentLogger) {
        Formatter formatter = this.getFormatter(config);
        for (Handler handler : this.getHandlers()) {
            handler.setFormatter(formatter);
        }
    }

    static {
        LEVEL_MAP.put("all", Level.ALL);
        LEVEL_MAP.put("info", Level.INFO);
        LEVEL_MAP.put("debug", Level.FINE);
        LEVEL_MAP.put("fine", Level.FINE);
        LEVEL_MAP.put("finer", Level.FINER);
        LEVEL_MAP.put("trace", Level.FINEST);
        LEVEL_MAP.put("finest", Level.FINEST);
        LEVEL_MAP.put("warn", Level.WARNING);
        LEVEL_MAP.put("warning", Level.WARNING);
        LEVEL_MAP.put("error", Level.WARNING);
        LEVEL_MAP.put("severe", Level.SEVERE);
        LEVEL_MAP.put("fatal", Level.SEVERE);
        LEVEL_MAP.put("off", Level.OFF);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleLogger
    extends Logger
    implements IAgentLogger {
        protected SimpleLogger(String name, String resourceBundleName) {
            super(name, resourceBundleName);
        }

        @Override
        public void error(String s) {
            this.warning(s);
        }

        @Override
        public void debug(String s) {
            this.finer(s);
        }

        @Override
        public void trace(String s) {
            this.trace(s);
        }

        @Override
        public boolean isFineEnabled() {
            return this.isLoggable(Level.FINE);
        }

        @Override
        public boolean isFinerEnabled() {
            return this.isLoggable(Level.FINER);
        }

        @Override
        public boolean isFinestEnabled() {
            return this.isLoggable(Level.FINEST);
        }

        @Override
        public boolean isTraceEnabled() {
            return this.isLoggable(Level.FINEST);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.isLoggable(Level.FINE);
        }

        @Override
        public IAgentLogger getChildLogger(Class<?> clazz) {
            return null;
        }

        @Override
        public IAgentLogger getChildLogger(String fullName, String simpleName) {
            return null;
        }
    }

    private static class LogFormatter
    extends Formatter {
        Date dat = new Date();
        private static final String format = "{0,date} {0,time}";
        private MessageFormat formatter;
        private Object[] args = new Object[1];
        private final String lineSeparator = System.getProperty("line.separator");

        private LogFormatter() {
        }

        public synchronized String format(LogRecord record) {
            StringBuilder sb = new StringBuilder();
            this.dat.setTime(record.getMillis());
            this.args[0] = this.dat;
            StringBuffer text = new StringBuffer();
            if (this.formatter == null) {
                this.formatter = new MessageFormat(format);
            }
            this.formatter.format(this.args, text, (FieldPosition)null);
            sb.append(text);
            sb.append(" NewRelic ");
            String message = this.formatMessage(record);
            sb.append(record.getLevel().getLocalizedName());
            sb.append(": ");
            sb.append(message);
            sb.append(this.lineSeparator);
            if (record.getThrown() != null) {
                try {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    record.getThrown().printStackTrace(pw);
                    pw.close();
                    sb.append(sw.toString());
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            return sb.toString();
        }
    }
}

