/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.logging;

import com.newrelic.org.apache.log4j.Level;

public class CustomLevel
extends Level {
    private static final long serialVersionUID = 1L;
    private static String FINE_STR = "FINE";
    private static String FINER_STR = "FINER";
    private static String FINEST_STR = "FINEST";
    private static final int FINE_INT = 10001;
    private static final int FINER_INT = 10000;
    private static final int FINEST_INT = 5000;
    public static final CustomLevel FINE = new CustomLevel(10001, FINE_STR, 7);
    public static final CustomLevel FINER = new CustomLevel(10000, FINER_STR, 7);
    public static final CustomLevel FINEST = new CustomLevel(5000, FINEST_STR, 7);

    private CustomLevel(int level, String strLevel, int syslogEquiv) {
        super(level, strLevel, syslogEquiv);
    }

    public static Level toLevel(String sArg) {
        return CustomLevel.toLevel(sArg, (Level)FINER);
    }

    public static Level toLevel(String sArg, Level defaultValue) {
        if (sArg == null) {
            return defaultValue;
        }
        String stringVal = sArg.toUpperCase();
        if (stringVal.equals(FINE_STR)) {
            return FINE;
        }
        if (stringVal.equals(FINER_STR)) {
            return FINER;
        }
        if (stringVal.equals(FINEST_STR)) {
            return FINEST;
        }
        return Level.toLevel(sArg, defaultValue);
    }

    public static Level toLevel(int i) throws IllegalArgumentException {
        switch (i) {
            case 10001: {
                return FINE;
            }
            case 10000: {
                return FINER;
            }
            case 5000: {
                return FINEST;
            }
        }
        return Level.toLevel(i);
    }
}

