/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.logging;

import com.newrelic.agent.config.IAgentConfig;
import com.newrelic.agent.logging.IAgentLogManager;
import com.newrelic.agent.logging.IAgentLogger;
import com.newrelic.agent.logging.Log4jLevelHelper;
import com.newrelic.agent.logging.Log4jLogger;
import com.newrelic.agent.logging.LogFileHelper;
import com.newrelic.org.apache.log4j.Level;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;

public class Log4jLogManager
implements IAgentLogManager {
    private final Log4jLogger rootLogger;
    private volatile String logFilePath;

    private Log4jLogManager(String name) {
        this.rootLogger = this.initRootLogger(name);
        this.rootLogger.info("Agent is using Log4j");
    }

    private Log4jLogger createRootLogger(String name) {
        Log4jLogger logger = Log4jLogger.create(name);
        logger.setLevel(Level.INFO);
        logger.addConsoleAppender();
        return logger;
    }

    private Log4jLogger initRootLogger(String name) {
        Log4jLogger logger = null;
        try {
            String old = System.getProperty("log4j.defaultInitOverride", "false");
            System.setProperty("log4j.defaultInitOverride", Boolean.toString(true));
            logger = this.createRootLogger(name);
            System.setProperty("log4j.defaultInitOverride", old);
        }
        catch (SecurityException ex) {
            if (logger == null) {
                logger = this.createRootLogger(name);
            }
            String msg = MessageFormat.format("Error setting log4j.defaultInitOverride property: {0}", ex);
            logger.warning(msg);
        }
        return logger;
    }

    public IAgentLogger getRootLogger() {
        return this.rootLogger;
    }

    public String getLogFilePath() {
        return this.logFilePath;
    }

    public void configureLogger(IAgentConfig agentConfig) {
        this.configureLogLevel(agentConfig);
        this.configureConsoleHandler(agentConfig);
        this.configureFileHandler(agentConfig);
    }

    private void configureFileHandler(IAgentConfig agentConfig) {
        String logFileName = this.getLogFileName(agentConfig);
        if (logFileName == null) {
            return;
        }
        try {
            this.configureFileHandler(logFileName, agentConfig);
            this.logFilePath = logFileName;
            String msg = MessageFormat.format("Writing to New Relic log file: {0}", logFileName);
            this.rootLogger.info(msg);
        }
        catch (IOException e) {
            String msg = MessageFormat.format("Unable to configure newrelic log file: {0}", logFileName);
            this.rootLogger.error(msg);
            this.addConsoleHandler();
        }
    }

    private String getLogFileName(IAgentConfig agentConfig) {
        File logFile = LogFileHelper.getLogFile(agentConfig);
        return logFile == null ? null : logFile.getPath();
    }

    private void configureLogLevel(IAgentConfig agentConfig) {
        Level level = agentConfig.isDebugEnabled() ? Level.TRACE : Log4jLevelHelper.getLevel(agentConfig.getLogLevel());
        this.rootLogger.setLevel(level);
    }

    private void configureConsoleHandler(IAgentConfig agentConfig) {
        if (agentConfig.isDebugEnabled() || agentConfig.isLoggingToStdOut()) {
            this.addConsoleHandler();
        } else {
            this.rootLogger.removeConsoleAppender();
        }
    }

    private String configureFileHandler(String logFileName, IAgentConfig agentConfig) throws IOException {
        int limit = agentConfig.getLogLimit() * 1024;
        int fileCount = Math.max(1, agentConfig.getLogFileCount());
        this.rootLogger.addFileAppender(logFileName, limit, fileCount);
        return logFileName;
    }

    public void addConsoleHandler() {
        this.rootLogger.addConsoleAppender();
    }

    public void setLogLevel(String level) {
        this.rootLogger.setLevel(Log4jLevelHelper.getLevel(level));
    }

    public String getLogLevel() {
        return this.rootLogger.getLevel().toString();
    }

    public static Log4jLogManager create(String name) {
        return new Log4jLogManager(name);
    }
}

