/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.normalization;

import com.newrelic.agent.ConnectionListener;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.config.IAgentConfig;
import com.newrelic.agent.normalization.NormalizationRule;
import com.newrelic.agent.normalization.NormalizationRuleFactory;
import com.newrelic.agent.normalization.NormalizationService;
import com.newrelic.agent.normalization.Normalizer;
import com.newrelic.agent.normalization.NormalizerFactory;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NormalizationServiceImpl
extends AbstractService
implements NormalizationService,
ConnectionListener {
    private static final Pattern PARAMETER_DELIMITER_PATTERN = Pattern.compile("(.*?)(\\?|#|;).*", 32);
    private static final List<NormalizationRule> EMPTY_RULES = Collections.emptyList();
    private final ConcurrentMap<String, Normalizer> urlNormalizers = new ConcurrentHashMap<String, Normalizer>();
    private final ConcurrentMap<String, Normalizer> transactionNormalizers = new ConcurrentHashMap<String, Normalizer>();
    private final ConcurrentMap<String, Normalizer> metricNormalizers = new ConcurrentHashMap<String, Normalizer>();
    private volatile Normalizer defaultUrlNormalizer;
    private volatile Normalizer defaultTransactionNormalizer;
    private volatile Normalizer defaultMetricNormalizer;
    private final String defaultAppName;
    private final boolean autoAppNamingEnabled;

    public NormalizationServiceImpl() {
        super(NormalizationService.class.getSimpleName());
        IAgentConfig defaultAgentConfig = ServiceFactory.getConfigService().getDefaultAgentConfig();
        this.defaultAppName = defaultAgentConfig.getApplicationName();
        this.autoAppNamingEnabled = defaultAgentConfig.isAutoAppNamingEnabled();
        this.defaultUrlNormalizer = this.createUrlNormalizer(this.defaultAppName, EMPTY_RULES);
        this.defaultTransactionNormalizer = this.createTransactionNormalizer(this.defaultAppName, EMPTY_RULES);
        this.defaultMetricNormalizer = this.createMetricNormalizer(this.defaultAppName, EMPTY_RULES);
        ServiceFactory.getRPMServiceManager().addConnectionListener(this);
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
        ServiceFactory.getRPMServiceManager().removeConnectionListener(this);
    }

    @Override
    public String getUrlBeforeParameters(String url) {
        Matcher paramDelimiterMatcher = PARAMETER_DELIMITER_PATTERN.matcher(url);
        if (paramDelimiterMatcher.matches()) {
            return paramDelimiterMatcher.group(1);
        }
        return url;
    }

    @Override
    public Normalizer getUrlNormalizer(String appName) {
        return this.getOrCreateUrlNormalizer(appName);
    }

    @Override
    public Normalizer getTransactionNormalizer(String appName) {
        return this.getOrCreateTransactionNormalizer(appName);
    }

    @Override
    public Normalizer getMetricNormalizer(String appName) {
        return this.getOrCreateMetricNormalizer(appName);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void connected(IRPMService rpmService, Map<String, Object> data) {
        String appName = rpmService.getApplicationName();
        List<NormalizationRule> urlRules = NormalizationRuleFactory.getUrlRules(appName, data);
        List<NormalizationRule> metricNameRules = NormalizationRuleFactory.getMetricNameRules(appName, data);
        List<NormalizationRule> transactionNameRules = NormalizationRuleFactory.getTransactionNameRules(appName, data);
        Normalizer normalizer = this.createUrlNormalizer(appName, urlRules);
        this.replaceUrlNormalizer(appName, normalizer);
        normalizer = this.createTransactionNormalizer(appName, transactionNameRules);
        this.replaceTransactionNormalizer(appName, normalizer);
        normalizer = this.createMetricNormalizer(appName, metricNameRules);
        this.replaceMetricNormalizer(appName, normalizer);
    }

    @Override
    public void disconnected(IRPMService rpmService) {
    }

    private Normalizer getOrCreateUrlNormalizer(String appName) {
        Normalizer normalizer = this.findUrlNormalizer(appName);
        if (normalizer != null) {
            return normalizer;
        }
        normalizer = this.createUrlNormalizer(appName, EMPTY_RULES);
        Normalizer oldNormalizer = this.urlNormalizers.putIfAbsent(appName, normalizer);
        return oldNormalizer == null ? normalizer : oldNormalizer;
    }

    private Normalizer findUrlNormalizer(String appName) {
        if (!this.autoAppNamingEnabled || appName == null || appName.equals(this.defaultAppName)) {
            return this.defaultUrlNormalizer;
        }
        return (Normalizer)this.urlNormalizers.get(appName);
    }

    private void replaceUrlNormalizer(String appName, Normalizer normalizer) {
        Normalizer oldNormalizer = this.getUrlNormalizer(appName);
        if (oldNormalizer == this.defaultUrlNormalizer) {
            this.defaultUrlNormalizer = normalizer;
        } else {
            this.urlNormalizers.put(appName, normalizer);
        }
    }

    private Normalizer getOrCreateTransactionNormalizer(String appName) {
        Normalizer normalizer = this.findTransactionNormalizer(appName);
        if (normalizer != null) {
            return normalizer;
        }
        normalizer = this.createTransactionNormalizer(appName, EMPTY_RULES);
        Normalizer oldNormalizer = this.transactionNormalizers.putIfAbsent(appName, normalizer);
        return oldNormalizer == null ? normalizer : oldNormalizer;
    }

    private Normalizer findTransactionNormalizer(String appName) {
        if (!this.autoAppNamingEnabled || appName == null || appName.equals(this.defaultAppName)) {
            return this.defaultTransactionNormalizer;
        }
        return (Normalizer)this.transactionNormalizers.get(appName);
    }

    private void replaceTransactionNormalizer(String appName, Normalizer normalizer) {
        Normalizer oldNormalizer = this.getTransactionNormalizer(appName);
        if (oldNormalizer == this.defaultTransactionNormalizer) {
            this.defaultTransactionNormalizer = normalizer;
        } else {
            this.transactionNormalizers.put(appName, normalizer);
        }
    }

    private Normalizer getOrCreateMetricNormalizer(String appName) {
        Normalizer normalizer = this.findMetricNormalizer(appName);
        if (normalizer != null) {
            return normalizer;
        }
        normalizer = this.createMetricNormalizer(appName, EMPTY_RULES);
        Normalizer oldNormalizer = this.metricNormalizers.putIfAbsent(appName, normalizer);
        return oldNormalizer == null ? normalizer : oldNormalizer;
    }

    private Normalizer findMetricNormalizer(String appName) {
        if (!this.autoAppNamingEnabled || appName == null || appName.equals(this.defaultAppName)) {
            return this.defaultMetricNormalizer;
        }
        return (Normalizer)this.metricNormalizers.get(appName);
    }

    private void replaceMetricNormalizer(String appName, Normalizer normalizer) {
        Normalizer oldNormalizer = this.getMetricNormalizer(appName);
        if (oldNormalizer == this.defaultMetricNormalizer) {
            this.defaultMetricNormalizer = normalizer;
        } else {
            this.metricNormalizers.put(appName, normalizer);
        }
    }

    private Normalizer createUrlNormalizer(String appName, List<NormalizationRule> urlRules) {
        return NormalizerFactory.createUrlNormalizer(appName, urlRules);
    }

    private Normalizer createTransactionNormalizer(String appName, List<NormalizationRule> metricNameRules) {
        return NormalizerFactory.createTransactionNormalizer(appName, metricNameRules);
    }

    private Normalizer createMetricNormalizer(String appName, List<NormalizationRule> metricNameRules) {
        return NormalizerFactory.createMetricNormalizer(appName, metricNameRules);
    }
}

