/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile;

import com.newrelic.agent.TransactionData;
import com.newrelic.agent.TransactionListener;
import com.newrelic.agent.profile.Profile;
import com.newrelic.agent.profile.ProfilerParameters;
import com.newrelic.agent.profile.ThreadType;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.TransactionStats;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedTransactionProfile
extends Profile
implements TransactionListener {
    private final List<String> namedTransactions;
    private final Map<Long, BlockingQueue<StackTraceHolder>> pendingStackTraces = new ConcurrentHashMap<Long, BlockingQueue<StackTraceHolder>>();
    private final BlockingQueue<StackTraceHolder> releasedStackTraces = new LinkedBlockingQueue<StackTraceHolder>();

    public NamedTransactionProfile(ProfilerParameters parameters) {
        super(parameters);
        this.namedTransactions = parameters.getNamedTransactions();
    }

    @Override
    public void start() {
        ServiceFactory.getTransactionService().addTransactionListener(this);
        super.start();
    }

    @Override
    public void end() {
        ServiceFactory.getTransactionService().removeTransactionListener(this);
        this.pendingStackTraces.clear();
        this.releaseStackTraces();
        super.end();
    }

    private void releaseStackTraces() {
        StackTraceHolder holder;
        while ((holder = (StackTraceHolder)this.releasedStackTraces.poll()) != null) {
            super.addStackTrace(holder.getThreadId(), holder.isRunnable(), holder.getType(), holder.getStackTrace());
        }
        return;
    }

    @Override
    public void dispatcherTransactionFinished(TransactionData td, TransactionStats transactionStats) {
        BlockingQueue<StackTraceHolder> holderQueue = this.getHolderQueue(td.getThreadId());
        if (holderQueue == null) {
            return;
        }
        StackTraceHolder holder;
        while ((holder = (StackTraceHolder)holderQueue.poll()) != null) {
            if (!holder.capturesTransaction(td) || !this.isNamedTransaction(td)) continue;
            this.releasedStackTraces.add(holder);
        }
        return;
    }

    private boolean isNamedTransaction(TransactionData td) {
        return this.namedTransactions.contains(td.getBlameMetricName());
    }

    @Override
    public void sampleStackTraces() {
        this.releaseStackTraces();
        super.sampleStackTraces();
    }

    @Override
    protected void addStackTrace(long threadId, boolean runnable, ThreadType type, StackTraceElement ... stackTrace) {
        if (type != ThreadType.BasicThreadType.REQUEST) {
            super.addStackTrace(threadId, runnable, type, stackTrace);
            return;
        }
        StackTraceHolder holder = new StackTraceHolder(threadId, runnable, type, stackTrace);
        BlockingQueue<StackTraceHolder> holderQueue = this.getOrCreateHolderQueue(threadId);
        holderQueue.offer(holder);
    }

    private BlockingQueue<StackTraceHolder> getHolderQueue(long threadId) {
        return this.pendingStackTraces.get(threadId);
    }

    private BlockingQueue<StackTraceHolder> getOrCreateHolderQueue(long threadId) {
        BlockingQueue<StackTraceHolder> holderQueue = this.pendingStackTraces.get(threadId);
        if (holderQueue == null) {
            holderQueue = new LinkedBlockingQueue<StackTraceHolder>();
            this.pendingStackTraces.put(threadId, holderQueue);
        }
        return holderQueue;
    }

    private static class StackTraceHolder {
        private final long threadId;
        private final boolean runnable;
        private final ThreadType type;
        private final long stackTraceTime;
        private final StackTraceElement[] stackTrace;

        private StackTraceHolder(long threadId, boolean runnable, ThreadType type, StackTraceElement ... stackTrace) {
            this.threadId = threadId;
            this.runnable = runnable;
            this.type = type;
            this.stackTrace = stackTrace;
            this.stackTraceTime = System.nanoTime();
        }

        public long getThreadId() {
            return this.threadId;
        }

        public boolean isRunnable() {
            return this.runnable;
        }

        public ThreadType getType() {
            return this.type;
        }

        public StackTraceElement[] getStackTrace() {
            return this.stackTrace;
        }

        private boolean capturesTransaction(TransactionData td) {
            long startTime = td.getStartTimeInNanos();
            if (startTime > this.stackTraceTime) {
                return false;
            }
            long stopTime = td.getEndTimeInNanos();
            return stopTime >= this.stackTraceTime;
        }
    }
}

