/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile;

import com.newrelic.agent.Agent;
import com.newrelic.agent.ThreadService;
import com.newrelic.agent.TransactionService;
import com.newrelic.agent.profile.ProfileSegment;
import com.newrelic.agent.profile.ProfileTree;
import com.newrelic.agent.profile.ProfilerParameters;
import com.newrelic.agent.profile.RunnableThreadRules;
import com.newrelic.agent.profile.ThreadType;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.transport.DataSenderWriter;
import com.newrelic.agent.util.StackTraces;
import com.newrelic.org.json.simple.JSONArray;
import com.newrelic.org.json.simple.JSONStreamAware;
import java.io.IOException;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Profile
implements JSONStreamAware {
    public static final int MAX_STACK_DEPTH = 300;
    public static final int MAX_STACK_SIZE = 60000;
    private long startTimeMillis = 0L;
    private long endTimeMillis = 0L;
    private int sampleCount = 0;
    private int totalThreadCount = 0;
    private int runnableThreadCount = 0;
    private Map<Long, Long> startThreadCpuTimes;
    private final ProfilerParameters profilerParameters;
    private final Map<ThreadType, ProfileTree> profileTrees = new HashMap<ThreadType, ProfileTree>();

    public Profile(ProfilerParameters parameters) {
        this.profilerParameters = parameters;
    }

    private Map<Long, Long> getThreadCpuTimes() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        if (!threadMXBean.isThreadCpuTimeSupported() || !threadMXBean.isThreadCpuTimeEnabled()) {
            return Collections.emptyMap();
        }
        HashMap<Long, Long> cpuTimes = new HashMap<Long, Long>();
        for (long id : threadMXBean.getAllThreadIds()) {
            cpuTimes.put(id, threadMXBean.getThreadCpuTime(id));
        }
        return cpuTimes;
    }

    public ProfileTree getProfileTree(ThreadType threadType) {
        ProfileTree profileTree = this.profileTrees.get(threadType);
        if (profileTree == null) {
            profileTree = new ProfileTree();
            this.profileTrees.put(threadType, profileTree);
        }
        return profileTree;
    }

    public void start() {
        this.startTimeMillis = System.currentTimeMillis();
        this.startThreadCpuTimes = this.getThreadCpuTimes();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        if (!threadMXBean.isThreadCpuTimeSupported()) {
            Agent.LOG.info("Profile unable to record CPU time: Thread CPU time measurement is not supported");
        } else if (!threadMXBean.isThreadCpuTimeEnabled()) {
            Agent.LOG.info("Profile unable to record CPU time: Thread CPU time measurement is not enabled");
        }
    }

    public void end() {
        this.endTimeMillis = System.currentTimeMillis();
        Map<Long, Long> endThreadCpuTimes = this.getThreadCpuTimes();
        ThreadService threadService = ServiceFactory.getThreadService();
        Set<Long> requestThreadIds = threadService.getRequestThreadIds();
        Set<Long> backgroundThreadIds = threadService.getBackgroundThreadIds();
        Set<Long> agentThreadIds = threadService.getAgentThreadIds();
        for (Map.Entry<Long, Long> entry : endThreadCpuTimes.entrySet()) {
            Long startTime = this.startThreadCpuTimes.get(entry.getKey());
            if (startTime == null) {
                startTime = 0L;
            }
            long cpuTime = TimeUnit.MILLISECONDS.convert(entry.getValue() - startTime, TimeUnit.NANOSECONDS);
            ProfileTree tree = requestThreadIds.contains(entry.getKey()) ? this.getProfileTree(ThreadType.BasicThreadType.REQUEST) : (backgroundThreadIds.contains(entry.getKey()) ? this.getProfileTree(ThreadType.BasicThreadType.BACKGROUND) : (agentThreadIds.contains(entry.getKey()) ? this.getProfileTree(ThreadType.BasicThreadType.AGENT) : this.getProfileTree(ThreadType.BasicThreadType.OTHER)));
            tree.incrementCpuTime(cpuTime);
        }
        int stackCount = this.getCallSiteCount();
        String msg = MessageFormat.format("Profile size is {0} stack elements", stackCount);
        Agent.LOG.info(msg);
        if (stackCount > 60000) {
            Agent.LOG.info(MessageFormat.format("Trimmed profile size by {0} stack elements", this.trim(stackCount - 60000, stackCount)));
        }
    }

    public int trimBy(int limit) {
        return this.trim(limit, this.getCallSiteCount());
    }

    private int trim(int limit, int stackCount) {
        ProfileSegmentSort[] segments = this.getSortedSegments(stackCount);
        int count = 0;
        for (ProfileSegmentSort segment : segments) {
            if (count >= limit) break;
            segment.remove();
            ++count;
        }
        return count;
    }

    private ProfileSegmentSort[] getSortedSegments(int stackCount) {
        Object[] segments = new ProfileSegmentSort[stackCount];
        int index = 0;
        for (ProfileTree profileTree : this.profileTrees.values()) {
            for (ProfileSegment rootSegment : profileTree.getRootSegments()) {
                index = this.addSegment(rootSegment, null, 1, (ProfileSegmentSort[])segments, index);
            }
        }
        Arrays.sort(segments);
        return segments;
    }

    private int addSegment(ProfileSegment segment, ProfileSegment parent, int depth, ProfileSegmentSort[] segments, int index) {
        ProfileSegmentSort segSort = new ProfileSegmentSort(segment, parent, depth);
        segments[index++] = segSort;
        for (ProfileSegment child : segment.getChildren()) {
            index = this.addSegment(child, segment, ++depth, segments, index);
        }
        return index;
    }

    private int getCallSiteCount() {
        int count = 0;
        for (ProfileTree profileTree : this.profileTrees.values()) {
            count += profileTree.getCallSiteCount();
        }
        return count;
    }

    public Long getProfileId() {
        return this.profilerParameters.getProfileId();
    }

    public ProfilerParameters getProfilerParameters() {
        return this.profilerParameters;
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    public final long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public final long getEndTimeMillis() {
        return this.endTimeMillis;
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        JSONArray.writeJSONString(Arrays.asList(this.profilerParameters.getProfileId(), this.startTimeMillis, this.endTimeMillis, this.sampleCount, this.compressedData(out), this.totalThreadCount, this.runnableThreadCount), out);
    }

    private String compressedData(Writer out) {
        String result = DataSenderWriter.getJsonifiedCompressedEncodedString(this.profileTrees, out, 1);
        if (DataSenderWriter.isCompressingWriter(out)) {
            String msg = MessageFormat.format("Profile serialized size = {0} bytes", result.length());
            Agent.LOG.info(msg);
        }
        return result;
    }

    public void sampleStackTraces() {
        ThreadService threadService = ServiceFactory.getThreadService();
        HashSet<Long> requestThreadIds = new HashSet<Long>(threadService.getRequestThreadIds());
        HashSet<Long> backgroundThreadIds = new HashSet<Long>(threadService.getBackgroundThreadIds());
        Set<Long> agentThreadIds = threadService.getAgentThreadIds();
        TransactionService transactionService = ServiceFactory.getTransactionService();
        Set<Long> runningThreadsIds = transactionService.getRunningThreadsIds();
        requestThreadIds.retainAll(runningThreadsIds);
        backgroundThreadIds.retainAll(runningThreadsIds);
        ThreadInfo[] threadInfos = this.profilerParameters.isRequestThreadsOnly() ? this.getRequestThreadInfos(requestThreadIds) : this.getThreadInfos();
        if (threadInfos.length == 0) {
            return;
        }
        try {
            ++this.sampleCount;
            RunnableThreadRules runnableThreadRules = new RunnableThreadRules();
            for (ThreadInfo thread : threadInfos) {
                if (thread == null) continue;
                boolean runnable = runnableThreadRules.isRunnable(thread);
                if (this.profilerParameters.isRunnablesOnly() && !runnable) continue;
                long threadId = thread.getThreadId();
                ThreadType.BasicThreadType type = agentThreadIds.contains(threadId) ? ThreadType.BasicThreadType.AGENT : (this.profilerParameters.isProfileAgentThreads() && StackTraces.isInAgentInstrumentation(thread.getStackTrace()) ? ThreadType.BasicThreadType.AGENT_INSTRUMENTATION : (requestThreadIds.contains(threadId) ? ThreadType.BasicThreadType.REQUEST : (backgroundThreadIds.contains(threadId) ? ThreadType.BasicThreadType.BACKGROUND : ThreadType.BasicThreadType.OTHER)));
                this.addStackTrace(threadId, runnable, type, thread.getStackTrace());
            }
        }
        catch (SecurityException e) {
            Agent.LOG.finer(MessageFormat.format("An error occurred getting thread info: {0}", e.toString()));
            return;
        }
    }

    private ThreadInfo[] getThreadInfos() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        long[] threadIds = threadMXBean.getAllThreadIds();
        HashSet<Long> ids = new HashSet<Long>(threadIds.length);
        for (long threadId : threadIds) {
            ids.add(threadId);
        }
        ids.remove(Thread.currentThread().getId());
        threadIds = this.convertToLongArray(ids);
        return threadMXBean.getThreadInfo(threadIds, 300);
    }

    private ThreadInfo[] getRequestThreadInfos(Set<Long> requestThreadIds) {
        long[] threadIds = this.convertToLongArray(requestThreadIds);
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        return threadMXBean.getThreadInfo(threadIds, 300);
    }

    private long[] convertToLongArray(Set<Long> ids) {
        long[] arr = new long[ids.size()];
        int i = 0;
        for (Long id : ids) {
            arr[i++] = id;
        }
        return arr;
    }

    private void incrementThreadCounts(boolean runnable) {
        ++this.totalThreadCount;
        if (runnable) {
            ++this.runnableThreadCount;
        }
    }

    private boolean shouldScrubStack(ThreadType type) {
        if (ThreadType.BasicThreadType.AGENT.equals(type)) {
            return false;
        }
        return !this.profilerParameters.isProfileAgentThreads();
    }

    protected void addStackTrace(long threadId, boolean runnable, ThreadType type, StackTraceElement ... stackTrace) {
        if (stackTrace.length < 2) {
            return;
        }
        this.incrementThreadCounts(runnable);
        List<StackTraceElement> stackTraceList = this.shouldScrubStack(type) ? StackTraces.scrubAndTruncate(Arrays.asList(stackTrace), 0) : Arrays.asList(stackTrace);
        ArrayList<StackTraceElement> result = new ArrayList<StackTraceElement>(stackTraceList);
        Collections.reverse(result);
        this.getProfileTree(type).addStackTrace(result, runnable);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProfileSegmentSort
    implements Comparable<ProfileSegmentSort> {
        private final ProfileSegment segment;
        private final ProfileSegment parent;
        private final int depth;

        private ProfileSegmentSort(ProfileSegment segment, ProfileSegment parent, int depth) {
            this.segment = segment;
            this.parent = parent;
            this.depth = depth;
        }

        void remove() {
            if (this.parent != null) {
                this.parent.removeChild(this.segment.getMethod());
            }
        }

        public String toString() {
            return this.segment.toString();
        }

        @Override
        public int compareTo(ProfileSegmentSort other) {
            int otherCount;
            int thisCount = this.segment.getRunnableCallCount();
            if (thisCount == (otherCount = other.segment.getRunnableCallCount())) {
                return this.depth > other.depth ? -1 : (this.depth == other.depth ? 0 : 1);
            }
            return thisCount > otherCount ? 1 : -1;
        }
    }
}

