/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile;

import com.newrelic.agent.IgnoreSilentlyException;
import com.newrelic.agent.logging.IAgentLogger;
import com.newrelic.agent.profile.NamedTransactionProfile;
import com.newrelic.agent.profile.Profile;
import com.newrelic.agent.profile.ProfilerParameters;
import com.newrelic.agent.profile.ProfilerService;
import com.newrelic.agent.service.ServiceFactory;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

public class ProfileSession {
    private final Profile profile;
    private final ProfilerService profilerService;
    private final AtomicBoolean done = new AtomicBoolean(false);
    private final AtomicReference<ScheduledFuture<?>> profileHandle = new AtomicReference();
    private final AtomicReference<ScheduledFuture<?>> timeoutHandle = new AtomicReference();

    public ProfileSession(ProfilerService profilerService, ProfilerParameters parameters) {
        this.profilerService = profilerService;
        this.profile = this.createProfile(parameters);
    }

    private Profile createProfile(ProfilerParameters parameters) {
        List<String> namedTransactions = parameters.getNamedTransactions();
        if (namedTransactions == null || namedTransactions.isEmpty()) {
            return new Profile(parameters);
        }
        this.getLogger().info(MessageFormat.format("Profiling named transaction: {0}", namedTransactions));
        return new NamedTransactionProfile(parameters);
    }

    void start(long samplePeriodInMillis, long durationInMillis) {
        this.profile.start();
        if (samplePeriodInMillis == durationInMillis) {
            this.getLogger().info("Starting single sample profiling session");
            this.startSingleSample();
        } else {
            this.getLogger().info(MessageFormat.format("Starting profiling session. Duration: {0} ms, sample period: {1} ms", durationInMillis, samplePeriodInMillis));
            this.startMultiSample(samplePeriodInMillis, durationInMillis);
        }
    }

    private void startMultiSample(long samplePeriodInMillis, long durationInMillis) {
        ScheduledExecutorService scheduler = this.profilerService.getScheduledExecutorService();
        ScheduledFuture<?> handle = scheduler.scheduleWithFixedDelay(new Runnable(){

            public void run() {
                try {
                    ProfileSession.this.profile.sampleStackTraces();
                }
                catch (Throwable t) {
                    String msg = MessageFormat.format("An error occurred collecting a thread sample: {0}", t.toString());
                    if (ProfileSession.this.getLogger().isLoggable(Level.FINER)) {
                        ProfileSession.this.getLogger().log(Level.SEVERE, msg, t);
                    }
                    ProfileSession.this.getLogger().severe(msg);
                }
            }
        }, 0L, samplePeriodInMillis, TimeUnit.MILLISECONDS);
        this.profileHandle.set(handle);
        handle = scheduler.schedule(new Runnable(){

            public void run() {
                ((ScheduledFuture)ProfileSession.this.profileHandle.get()).cancel(false);
                if (!ProfileSession.this.done.getAndSet(true)) {
                    ProfileSession.this.report();
                }
                ProfileSession.this.sessionCompleted();
            }
        }, durationInMillis, TimeUnit.MILLISECONDS);
        this.timeoutHandle.set(handle);
    }

    private void startSingleSample() {
        ScheduledExecutorService scheduler = this.profilerService.getScheduledExecutorService();
        ScheduledFuture<?> handle = scheduler.schedule(new Runnable(){

            public void run() {
                try {
                    ProfileSession.this.profile.sampleStackTraces();
                }
                catch (Throwable t) {
                    String msg = MessageFormat.format("An error occurred collecting a thread sample: {0}", t.toString());
                    if (ProfileSession.this.getLogger().isLoggable(Level.FINER)) {
                        ProfileSession.this.getLogger().log(Level.SEVERE, msg, t);
                    }
                    ProfileSession.this.getLogger().severe(msg);
                }
                if (!ProfileSession.this.done.getAndSet(true)) {
                    ProfileSession.this.report();
                }
                ProfileSession.this.sessionCompleted();
            }
        }, 0L, TimeUnit.MILLISECONDS);
        this.profileHandle.set(handle);
    }

    private void report() {
        this.profile.end();
        this.getLogger().info(MessageFormat.format("Profiler finished with {0} samples", this.profile.getSampleCount()));
        List<Profile> profiles = Arrays.asList(this.profile);
        try {
            List<Long> ids = ServiceFactory.getRPMService().sendProfileData(profiles);
            this.getLogger().info(MessageFormat.format("Server profile ids: {0}", ids));
        }
        catch (IgnoreSilentlyException e) {
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Unable to send profile data: {0}", e.toString());
            if (this.getLogger().isLoggable(Level.FINER)) {
                this.getLogger().log(Level.SEVERE, msg, e);
            }
            this.getLogger().severe(msg);
        }
    }

    private void sessionCompleted() {
        this.profilerService.sessionCompleted(this);
    }

    void stop(final boolean shouldReport) {
        if (this.done.getAndSet(true)) {
            return;
        }
        this.getLogger().log(Level.INFO, "Stopping profiling session");
        ScheduledFuture<?> handle = this.profileHandle.get();
        if (handle != null) {
            handle.cancel(false);
        }
        if ((handle = this.timeoutHandle.get()) != null) {
            handle.cancel(false);
        }
        this.profilerService.getScheduledExecutorService().schedule(new Runnable(){

            public void run() {
                if (shouldReport) {
                    ProfileSession.this.report();
                }
                ProfileSession.this.sessionCompleted();
            }
        }, 0L, TimeUnit.MILLISECONDS);
    }

    public boolean isDone() {
        return this.done.get();
    }

    public Long getProfileId() {
        return this.profile.getProfileId();
    }

    public Profile getProfile() {
        return this.profile;
    }

    private IAgentLogger getLogger() {
        return this.profilerService.getLogger();
    }
}

