/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile;

import com.newrelic.agent.profile.ProfileSession;
import com.newrelic.agent.profile.ProfilerControl;
import com.newrelic.agent.profile.ProfilerParameters;
import com.newrelic.agent.profile.StartProfilerCommand;
import com.newrelic.agent.profile.StopProfilerCommand;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.util.DefaultThreadFactory;
import java.text.MessageFormat;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class ProfilerService
extends AbstractService
implements ProfilerControl {
    private static final String PROFILER_THREAD_NAME = "New Relic Profiler Service";
    private ProfileSession currentSession;
    private final ScheduledExecutorService scheduledExecutor;

    public ProfilerService() {
        super(ProfilerService.class.getSimpleName());
        DefaultThreadFactory threadFactory = new DefaultThreadFactory(PROFILER_THREAD_NAME, true);
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor(threadFactory);
    }

    public boolean isEnabled() {
        return ServiceFactory.getConfigService().getDefaultAgentConfig().getThreadProfilerConfig().isEnabled();
    }

    public synchronized void startProfiler(ProfilerParameters parameters, long samplePeriodInMillis, long durationInMillis) {
        boolean enabled = ServiceFactory.getConfigService().getDefaultAgentConfig().getThreadProfilerConfig().isEnabled();
        if (!enabled || samplePeriodInMillis <= 0L || durationInMillis <= 0L || samplePeriodInMillis > durationInMillis) {
            this.getLogger().info(MessageFormat.format("Ignoring the start profiler command: enabled={0}, samplePeriodInMillis={1}, durationInMillis={2}", enabled, samplePeriodInMillis, durationInMillis));
            return;
        }
        ProfileSession oldSession = this.currentSession;
        if (oldSession != null && !oldSession.isDone()) {
            this.getLogger().info(MessageFormat.format("Ignoring the start profiler command because a session is currently active. {0}", oldSession.getProfileId()));
            return;
        }
        ProfileSession newSession = this.createProfileSession(parameters);
        newSession.start(samplePeriodInMillis, durationInMillis);
        this.currentSession = newSession;
    }

    public synchronized int stopProfiler(Long profileId, boolean shouldReport) {
        ProfileSession session = this.currentSession;
        if (session != null && profileId.equals(session.getProfileId())) {
            session.stop(shouldReport);
            return 0;
        }
        return -1;
    }

    synchronized void sessionCompleted(ProfileSession session) {
        if (this.currentSession != session) {
            return;
        }
        this.currentSession = null;
    }

    protected ProfileSession createProfileSession(ProfilerParameters parameters) {
        return new ProfileSession(this, parameters);
    }

    protected ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutor;
    }

    protected void doStart() {
        this.addCommands();
    }

    protected synchronized ProfileSession getCurrentSession() {
        return this.currentSession;
    }

    private void addCommands() {
        ServiceFactory.getCommandParser().addCommands(new StartProfilerCommand(this));
        ServiceFactory.getCommandParser().addCommands(new StopProfilerCommand(this));
    }

    protected void doStop() {
        ProfileSession session = this.getCurrentSession();
        if (session != null) {
            session.stop(false);
        }
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdown();
            try {
                if (!this.scheduledExecutor.awaitTermination(30L, TimeUnit.SECONDS)) {
                    this.getLogger().log(Level.FINE, "Profiler Service executor service did not terminate");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

