/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service;

import com.newrelic.agent.EnvironmentService;
import com.newrelic.agent.EnvironmentServiceImpl;
import com.newrelic.agent.GCService;
import com.newrelic.agent.HarvestService;
import com.newrelic.agent.HarvestServiceImpl;
import com.newrelic.agent.IAgent;
import com.newrelic.agent.RPMServiceManager;
import com.newrelic.agent.RPMServiceManagerImpl;
import com.newrelic.agent.ThreadService;
import com.newrelic.agent.TracerService;
import com.newrelic.agent.TransactionService;
import com.newrelic.agent.beacon.BeaconService;
import com.newrelic.agent.beacon.BeaconServiceImpl;
import com.newrelic.agent.cache.CacheService;
import com.newrelic.agent.cache.CacheServiceImpl;
import com.newrelic.agent.commands.CommandParser;
import com.newrelic.agent.config.ConfigService;
import com.newrelic.agent.config.ConfigServiceFactory;
import com.newrelic.agent.config.ConfigurationException;
import com.newrelic.agent.database.DatabaseService;
import com.newrelic.agent.database.DatabaseServiceImpl;
import com.newrelic.agent.deadlock.DeadlockDetectorService;
import com.newrelic.agent.extension.ExtensionService;
import com.newrelic.agent.instrumentation.ClassTransformerService;
import com.newrelic.agent.instrumentation.ClassTransformerServiceImpl;
import com.newrelic.agent.jmx.JmxService;
import com.newrelic.agent.normalization.NormalizationService;
import com.newrelic.agent.normalization.NormalizationServiceImpl;
import com.newrelic.agent.profile.ProfilerService;
import com.newrelic.agent.rpm.RPMConnectionService;
import com.newrelic.agent.rpm.RPMConnectionServiceImpl;
import com.newrelic.agent.samplers.CPUSamplerService;
import com.newrelic.agent.samplers.NoopSamplerService;
import com.newrelic.agent.samplers.SamplerService;
import com.newrelic.agent.samplers.SamplerServiceImpl;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.NoopService;
import com.newrelic.agent.service.Service;
import com.newrelic.agent.service.ServiceManager;
import com.newrelic.agent.servlet.ServletService;
import com.newrelic.agent.servlet.ServletServiceImpl;
import com.newrelic.agent.sql.SqlTraceService;
import com.newrelic.agent.sql.SqlTraceServiceImpl;
import com.newrelic.agent.stats.StatsService;
import com.newrelic.agent.stats.StatsServiceImpl;
import com.newrelic.agent.trace.TransactionTraceService;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceManagerImpl
extends AbstractService
implements ServiceManager {
    private final Map<String, Service> services = new HashMap<String, Service>();
    private volatile ExtensionService extensionService;
    private volatile ProfilerService profilerService;
    private volatile TracerService tracerService;
    private volatile TransactionTraceService transactionTraceService;
    private volatile ThreadService threadService;
    private volatile HarvestService harvestService;
    private volatile Service gcService;
    private volatile TransactionService transactionService;
    private volatile JmxService jmxService;
    private volatile CommandParser commandParser;
    private volatile RPMServiceManager rpmServiceManager;
    private volatile Service cpuSamplerService;
    private volatile DeadlockDetectorService deadlockDetectorService;
    private volatile SamplerService samplerService;
    private volatile ConfigService configService;
    private volatile RPMConnectionService rpmConnectionService;
    private volatile EnvironmentService environmentService;
    private volatile ClassTransformerService classTransformerService;
    private volatile StatsService statsService;
    private volatile SqlTraceService sqlTraceService;
    private volatile DatabaseService databaseService;
    private volatile BeaconService beaconService;
    private volatile CacheService cacheService;
    private volatile ServletService servletService;
    private volatile NormalizationService normalizationService;
    private final IAgent agentService;

    public ServiceManagerImpl(IAgent agent) throws ConfigurationException {
        super(ServiceManagerImpl.class.getSimpleName());
        this.agentService = agent;
        this.configService = ConfigServiceFactory.createConfigService();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    protected synchronized void doStart() throws Exception {
        this.agentService.start();
        this.classTransformerService = new ClassTransformerServiceImpl();
        this.jmxService = new JmxService();
        this.extensionService = new ExtensionService();
        this.tracerService = new TracerService();
        this.threadService = new ThreadService();
        this.cacheService = new CacheServiceImpl();
        this.extensionService.start();
        this.classTransformerService.start();
        boolean realAgent = this.agentService.getInstrumentation() != null;
        this.statsService = new StatsServiceImpl();
        this.environmentService = new EnvironmentServiceImpl();
        this.rpmConnectionService = new RPMConnectionServiceImpl();
        this.transactionService = new TransactionService();
        this.rpmServiceManager = new RPMServiceManagerImpl();
        this.normalizationService = new NormalizationServiceImpl();
        this.harvestService = new HarvestServiceImpl();
        this.gcService = realAgent ? new GCService() : new NoopService("GC Service");
        this.transactionTraceService = new TransactionTraceService();
        this.profilerService = new ProfilerService();
        this.commandParser = new CommandParser();
        this.cpuSamplerService = realAgent ? new CPUSamplerService() : new NoopService("CPU Sampler");
        this.deadlockDetectorService = new DeadlockDetectorService();
        this.samplerService = (SamplerService)((Object)(realAgent ? new SamplerServiceImpl() : new NoopSamplerService()));
        this.sqlTraceService = new SqlTraceServiceImpl();
        this.databaseService = new DatabaseServiceImpl();
        this.beaconService = new BeaconServiceImpl();
        this.servletService = new ServletServiceImpl();
        this.threadService.start();
        this.statsService.start();
        this.environmentService.start();
        this.rpmConnectionService.start();
        this.tracerService.start();
        this.harvestService.start();
        this.gcService.start();
        this.transactionService.start();
        this.transactionTraceService.start();
        this.profilerService.start();
        this.commandParser.start();
        this.jmxService.start();
        this.cpuSamplerService.start();
        this.deadlockDetectorService.start();
        this.samplerService.start();
        this.sqlTraceService.start();
        this.beaconService.start();
        this.cacheService.start();
        this.servletService.start();
        this.normalizationService.start();
        this.databaseService.start();
        this.configService.start();
        this.startServices();
        this.rpmServiceManager.start();
    }

    @Override
    protected synchronized void doStop() throws Exception {
        this.configService.stop();
        this.classTransformerService.stop();
        this.agentService.stop();
        this.rpmConnectionService.stop();
        this.deadlockDetectorService.stop();
        this.harvestService.stop();
        this.cpuSamplerService.stop();
        this.samplerService.stop();
        this.sqlTraceService.stop();
        this.normalizationService.stop();
        this.databaseService.stop();
        this.extensionService.stop();
        this.transactionService.stop();
        this.tracerService.stop();
        this.threadService.stop();
        this.transactionTraceService.stop();
        this.profilerService.stop();
        this.commandParser.stop();
        this.jmxService.stop();
        this.rpmServiceManager.stop();
        this.environmentService.stop();
        this.statsService.stop();
        this.beaconService.stop();
        this.cacheService.stop();
        this.servletService.stop();
        this.stopServices();
    }

    private void startServices() throws Exception {
        for (Service service : this.getServices().values()) {
            service.start();
        }
    }

    private void stopServices() throws Exception {
        for (Service service : this.getServices().values()) {
            service.stop();
        }
    }

    @Override
    public synchronized void addService(Service service) {
        this.services.put(service.getName(), service);
    }

    private Map<String, Service> getServices() {
        return Collections.unmodifiableMap(this.services);
    }

    @Override
    public synchronized Map<String, Map<String, Object>> getServicesConfiguration() {
        HashMap<String, Map<String, Object>> config = new HashMap<String, Map<String, Object>>();
        HashMap<String, Boolean> serviceInfo = new HashMap<String, Boolean>();
        serviceInfo.put("enabled", this.transactionService.isEnabled());
        config.put("TransactionService", serviceInfo);
        serviceInfo = new HashMap();
        config.put("TransactionTraceService", serviceInfo);
        serviceInfo.put("enabled", this.transactionTraceService.isEnabled());
        serviceInfo = new HashMap();
        serviceInfo.put("enabled", this.profilerService.isEnabled());
        config.put("ProfilerService", serviceInfo);
        serviceInfo = new HashMap();
        serviceInfo.put("enabled", true);
        config.put("StallService", serviceInfo);
        serviceInfo = new HashMap();
        serviceInfo.put("enabled", this.tracerService.isEnabled());
        config.put("TracerService", serviceInfo);
        serviceInfo = new HashMap();
        serviceInfo.put("enabled", this.commandParser.isEnabled());
        config.put("CommandParser", serviceInfo);
        serviceInfo = new HashMap();
        serviceInfo.put("enabled", this.jmxService.isEnabled());
        config.put("JmxService", serviceInfo);
        serviceInfo = new HashMap();
        serviceInfo.put("enabled", this.threadService.isEnabled());
        config.put("ThreadService", serviceInfo);
        for (Service service : this.getServices().values()) {
            serviceInfo = new HashMap();
            serviceInfo.put("enabled", service.isEnabled());
            config.put(service.getClass().getSimpleName(), serviceInfo);
        }
        return config;
    }

    @Override
    public synchronized Service getService(String name) {
        return this.services.get(name);
    }

    @Override
    public ExtensionService getExtensionService() {
        return this.extensionService;
    }

    @Override
    public ProfilerService getProfilerService() {
        return this.profilerService;
    }

    @Override
    public TracerService getTracerService() {
        return this.tracerService;
    }

    @Override
    public TransactionTraceService getTransactionTraceService() {
        return this.transactionTraceService;
    }

    @Override
    public ThreadService getThreadService() {
        return this.threadService;
    }

    @Override
    public HarvestService getHarvestService() {
        return this.harvestService;
    }

    @Override
    public TransactionService getTransactionService() {
        return this.transactionService;
    }

    @Override
    public JmxService getJmxService() {
        return this.jmxService;
    }

    @Override
    public CommandParser getCommandParser() {
        return this.commandParser;
    }

    @Override
    public RPMServiceManager getRPMServiceManager() {
        return this.rpmServiceManager;
    }

    @Override
    public SamplerService getSamplerService() {
        return this.samplerService;
    }

    @Override
    public IAgent getAgent() {
        return this.agentService;
    }

    @Override
    public ConfigService getConfigService() {
        return this.configService;
    }

    @Override
    public RPMConnectionService getRPMConnectionService() {
        return this.rpmConnectionService;
    }

    @Override
    public EnvironmentService getEnvironmentService() {
        return this.environmentService;
    }

    @Override
    public ClassTransformerService getClassTransformerService() {
        return this.classTransformerService;
    }

    @Override
    public StatsService getStatsService() {
        return this.statsService;
    }

    @Override
    public SqlTraceService getSqlTraceService() {
        return this.sqlTraceService;
    }

    @Override
    public DatabaseService getDatabaseService() {
        return this.databaseService;
    }

    @Override
    public CacheService getCacheService() {
        return this.cacheService;
    }

    @Override
    public ServletService getServletService() {
        return this.servletService;
    }

    @Override
    public BeaconService getBeaconService() {
        return this.beaconService;
    }

    @Override
    public NormalizationService getNormalizationService() {
        return this.normalizationService;
    }
}

