/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.servlet;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.cache.CacheService;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.servlet.ServletService;
import com.newrelic.agent.tracers.servlet.FilterConfig;
import com.newrelic.agent.tracers.servlet.FilterConfigExtension;
import com.newrelic.agent.tracers.servlet.HttpRequest;
import com.newrelic.agent.tracers.servlet.HttpServletRequest;
import com.newrelic.agent.tracers.servlet.ServletConfig;
import com.newrelic.agent.tracers.servlet.ServletConfigExtension;
import com.newrelic.agent.tracers.servlet.ServletContext;
import com.newrelic.agent.tracers.servlet.ServletExtension;
import com.newrelic.agent.util.Invoker;
import com.newrelic.agent.util.SingleClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletServiceImpl
extends AbstractService
implements ServletService {
    public static final String APPLICATION_NAME_PARAM = "com.newrelic.agent.APPLICATION_NAME";
    public static final String TRANSACTION_NAME_PARAM = "com.newrelic.agent.TRANSACTION_NAME";
    private static final int PARAMETER_VALUE_MAX_LENGTH = 2048;
    private static final String FILTER_CONFIG_INTERFACE = "javax.servlet.FilterConfig";
    private static final String SERVLET_CONFIG_INTERFACE = "javax.servlet.ServletConfig";
    private static final String SERVLET_CONTEXT_INTERFACE = "javax.servlet.ServletContext";
    private static final String SERVLET_REQUEST_INTERFACE = "javax.servlet.ServletRequest";
    private static final String SERVLET_INTERFACE = "javax.servlet.Servlet";
    private static final String GET_ATTRIBUTE_METHOD = "getAttribute";
    private static final String GET_CONTEXT_PATH_METHOD = "getContextPath";
    private static final String GET_FILTER_NAME_METHOD = "getFilterName";
    private static final String GET_INIT_PARAMETER_METHOD = "getInitParameter";
    private static final String GET_PARAMETERS_METHOD = "getParameters";
    private static final String GET_PARAMETER_VALUES_METHOD = "getParameterValues";
    private static final String GET_SERVER_INFO_METHOD = "getServerInfo";
    private static final String GET_SERVLET_CONFIG_METHOD = "getServletConfig";
    private static final String GET_SERVLET_CONTEXT_METHOD = "getServletContext";
    private static final String GET_SERVLET_CONTEXT_NAME_METHOD = "getServletContextName";
    private static final String GET_SERVLET_NAME_METHOD = "getServletName";
    private final SingleClassLoader servletConfigInterfaceLoader;
    private final SingleClassLoader servletInterfaceLoader;
    private final SingleClassLoader filterConfigInterfaceLoader;
    private final SingleClassLoader servletContextInterfaceLoader;
    private final SingleClassLoader servletRequestInterfaceLoader;

    public ServletServiceImpl() {
        super(ServletService.class.getSimpleName());
        CacheService cacheService = ServiceFactory.getCacheService();
        this.servletConfigInterfaceLoader = cacheService.getSingleClassLoader(SERVLET_CONFIG_INTERFACE);
        this.servletInterfaceLoader = cacheService.getSingleClassLoader(SERVLET_INTERFACE);
        this.filterConfigInterfaceLoader = cacheService.getSingleClassLoader(FILTER_CONFIG_INTERFACE);
        this.servletContextInterfaceLoader = cacheService.getSingleClassLoader(SERVLET_CONTEXT_INTERFACE);
        this.servletRequestInterfaceLoader = cacheService.getSingleClassLoader(SERVLET_REQUEST_INTERFACE);
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }

    @Override
    public Object getAttributeForServletRequest(Object servletRequest, String name) throws Exception {
        if (servletRequest instanceof HttpServletRequest) {
            return ((HttpServletRequest)servletRequest).getAttribute(name);
        }
        if (servletRequest != null) {
            Class<?> clazz = this.servletRequestInterfaceLoader.loadClass(servletRequest.getClass().getClassLoader());
            return Invoker.invoke(servletRequest, clazz, GET_ATTRIBUTE_METHOD, name);
        }
        return null;
    }

    @Override
    public String getContextPathForServletContext(Object servletContext) throws Exception {
        if (servletContext != null) {
            Class<?> clazz = this.servletContextInterfaceLoader.loadClass(servletContext.getClass().getClassLoader());
            return (String)Invoker.invoke(servletContext, clazz, GET_CONTEXT_PATH_METHOD, new Object[0]);
        }
        return null;
    }

    @Override
    public String getFilterName(Object filterConfig) throws Exception {
        if (filterConfig instanceof FilterConfig) {
            return ((FilterConfig)filterConfig).getFilterName();
        }
        Class<?> clazz = this.filterConfigInterfaceLoader.loadClass(filterConfig.getClass().getClassLoader());
        Object name = Invoker.invoke(filterConfig, clazz, GET_FILTER_NAME_METHOD, new Object[0]);
        if (name != null) {
            return (String)name;
        }
        return null;
    }

    @Override
    public Map<String, String[]> getFilteredParameterMap(Map<String, String[]> params, Set<String> excludes) {
        if (excludes.isEmpty()) {
            return params;
        }
        params = new HashMap<String, String[]>(params);
        for (String exclude : excludes) {
            params.remove(exclude);
        }
        return params;
    }

    @Override
    public String getInitParamForFilterConfig(Object filterConfig, String name) throws Exception {
        if (filterConfig instanceof FilterConfig) {
            return ((FilterConfig)filterConfig).getInitParameter(name);
        }
        if (filterConfig != null) {
            Class<?> clazz = this.filterConfigInterfaceLoader.loadClass(filterConfig.getClass().getClassLoader());
            Object application = Invoker.invoke(filterConfig, clazz, GET_INIT_PARAMETER_METHOD, name);
            if (application != null) {
                return (String)application;
            }
        }
        return null;
    }

    @Override
    public String getInitParamForServletConfig(Object servletConfig, String name) throws Exception {
        if (servletConfig instanceof ServletConfig) {
            return ((ServletConfig)servletConfig).getInitParameter(name);
        }
        if (servletConfig != null) {
            Class<?> clazz = this.servletConfigInterfaceLoader.loadClass(servletConfig.getClass().getClassLoader());
            Object application = Invoker.invoke(servletConfig, clazz, GET_INIT_PARAMETER_METHOD, name);
            if (application != null) {
                return (String)application;
            }
        }
        return null;
    }

    @Override
    public String getInitParamForServletContext(Object servletContext, String name) throws Exception {
        if (servletContext instanceof ServletContext) {
            return ((ServletContext)servletContext).getInitParameter(name);
        }
        if (servletContext != null) {
            Class<?> clazz = this.servletContextInterfaceLoader.loadClass(servletContext.getClass().getClassLoader());
            Object application = Invoker.invoke(servletContext, clazz, GET_INIT_PARAMETER_METHOD, name);
            if (application != null) {
                return (String)application;
            }
        }
        return null;
    }

    @Override
    public Enumeration<?> getParameterNamesForServletRequest(Object servletRequest) throws Exception {
        if (servletRequest instanceof HttpServletRequest) {
            return ((HttpServletRequest)servletRequest).getParameterNames();
        }
        if (servletRequest != null) {
            Class<?> clazz = this.servletRequestInterfaceLoader.loadClass(servletRequest.getClass().getClassLoader());
            return (Enumeration)Invoker.invoke(servletRequest, clazz, GET_PARAMETERS_METHOD, new Object[0]);
        }
        return null;
    }

    @Override
    public String[] getParameterValuesForServletRequest(Object servletRequest, String name) throws Exception {
        if (servletRequest instanceof HttpServletRequest) {
            return ((HttpServletRequest)servletRequest).getParameterValues(name);
        }
        if (servletRequest != null) {
            Class<?> clazz = this.servletRequestInterfaceLoader.loadClass(servletRequest.getClass().getClassLoader());
            return (String[])Invoker.invoke(servletRequest, clazz, GET_PARAMETER_VALUES_METHOD, name);
        }
        return null;
    }

    @Override
    public Object getServletConfigForServlet(Object servlet) throws Exception {
        if (servlet instanceof ServletExtension) {
            return ((ServletExtension)servlet)._nr_getServletConfig();
        }
        Class<?> clazz = this.servletInterfaceLoader.loadClass(servlet.getClass().getClassLoader());
        return Invoker.invoke(servlet, clazz, GET_SERVLET_CONFIG_METHOD, new Object[0]);
    }

    @Override
    public Object getServletContextForFilterConfig(Object filterConfig) throws Exception {
        if (filterConfig instanceof FilterConfigExtension) {
            return ((FilterConfigExtension)filterConfig)._nr_getServletContext();
        }
        Class<?> clazz = this.filterConfigInterfaceLoader.loadClass(filterConfig.getClass().getClassLoader());
        return Invoker.invoke(filterConfig, clazz, GET_SERVLET_CONTEXT_METHOD, new Object[0]);
    }

    @Override
    public Object getServletContextForServletConfig(Object servletConfig) throws Exception {
        if (servletConfig instanceof ServletConfigExtension) {
            return ((ServletConfigExtension)servletConfig)._nr_getServletContext();
        }
        if (servletConfig != null) {
            Class<?> clazz = this.servletConfigInterfaceLoader.loadClass(servletConfig.getClass().getClassLoader());
            return Invoker.invoke(servletConfig, clazz, GET_SERVLET_CONTEXT_METHOD, new Object[0]);
        }
        return null;
    }

    @Override
    public String getServletContextNameForServletContext(Object servletContext) throws Exception {
        Class<?> clazz;
        Object application;
        if (servletContext instanceof ServletContext) {
            return ((ServletContext)servletContext).getServletContextName();
        }
        if (servletContext != null && (application = Invoker.invoke(servletContext, clazz = this.servletContextInterfaceLoader.loadClass(servletContext.getClass().getClassLoader()), GET_SERVLET_CONTEXT_NAME_METHOD, new Object[0])) != null) {
            return (String)application;
        }
        return null;
    }

    @Override
    public String getServletInfoForServletContext(Object servletContext) throws Exception {
        if (servletContext instanceof ServletContext) {
            return ((ServletContext)servletContext).getServerInfo();
        }
        if (servletContext != null) {
            Class<?> clazz = this.servletContextInterfaceLoader.loadClass(servletContext.getClass().getClassLoader());
            return (String)Invoker.invoke(servletContext, clazz, GET_SERVER_INFO_METHOD, new Object[0]);
        }
        return null;
    }

    @Override
    public String getServletName(Object servletConfig) throws Exception {
        if (servletConfig instanceof ServletConfig) {
            return ((ServletConfig)servletConfig).getServletName();
        }
        if (servletConfig != null) {
            Class<?> clazz = this.servletConfigInterfaceLoader.loadClass(servletConfig.getClass().getClassLoader());
            return (String)Invoker.invoke(servletConfig, clazz, GET_SERVLET_NAME_METHOD, new Object[0]);
        }
        return null;
    }

    @Override
    public Map<String, String> getSimpleParameterMap(Map<String, String[]> parameterMap) {
        if (parameterMap == null || parameterMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            String name = entry.getKey();
            String[] values = entry.getValue();
            String value = this.getValue(values);
            parameters.put(name, value);
        }
        return parameters;
    }

    @Override
    public void recordParameters(Transaction tx, HttpRequest request) throws Exception {
        if (tx.isIgnore()) {
            return;
        }
        if (!tx.getAgentConfig().isCaptureParams()) {
            return;
        }
        Set<String> excludes = tx.getAgentConfig().getIgnoredParams();
        Map<String, String> requestParameters = this.getRequestParameterMap(excludes, request);
        if (requestParameters.isEmpty()) {
            return;
        }
        tx.getParameters().put("request_parameters", requestParameters);
    }

    private Map<String, String> getRequestParameterMap(Set<String> excludes, HttpRequest request) throws Exception {
        Enumeration<?> nameEnumeration = request.getParameterNames();
        if (nameEnumeration == null || !nameEnumeration.hasMoreElements()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        while (nameEnumeration.hasMoreElements()) {
            String[] values;
            String value;
            String name = nameEnumeration.nextElement().toString();
            if (excludes.contains(name) || (value = this.getValue(values = request.getParameterValues(name))) == null) continue;
            requestParameters.put(name, value);
        }
        return requestParameters;
    }

    private String getValue(String[] values) {
        String value;
        if (values == null || values.length == 0) {
            return null;
        }
        String string = value = values.length == 1 ? values[0] : Arrays.asList(values).toString();
        if (value.length() > 2048) {
            value = value.substring(2048);
        }
        return value;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

