/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.trace;

import com.newrelic.agent.Agent;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.trace.ITransactionSampler;
import com.newrelic.agent.trace.TransactionTrace;
import com.newrelic.agent.util.TimeConversion;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedTransactionSampler
implements ITransactionSampler {
    private static final TransactionData FINISHED = new TransactionData(null, null, 0, null, null, null, null, false, 0, null, 0, 0L, null, null, 0L, null, null, null);
    private final String appName;
    private final Set<String> transactionNames;
    private final int maxTraces;
    private final double duration;
    private final long stopTime;
    private final AtomicReference<TransactionData> expensiveTransaction = new AtomicReference();
    private volatile long maxDurationInNanos;
    private int tracesSent;

    protected NamedTransactionSampler(String appName, List<String> transactionNames, int maxTraces, Double duration) {
        this.appName = appName.intern();
        this.transactionNames = new HashSet<String>(transactionNames);
        this.maxTraces = maxTraces;
        this.duration = duration;
        long durationInNanos = TimeConversion.convertSecondsToNanos(duration);
        this.stopTime = System.nanoTime() + durationInNanos;
    }

    @Override
    public boolean noticeTransaction(TransactionData td) {
        TransactionData current;
        if (this.appName != td.getApplicationName()) {
            return false;
        }
        if (td.getDuration() <= this.maxDurationInNanos) {
            return false;
        }
        if (!this.transactionNames.contains(td.getBlameMetricName())) {
            return false;
        }
        do {
            if ((current = this.expensiveTransaction.get()) == FINISHED) {
                return false;
            }
            if (current == null || current.getDuration() < td.getDuration()) continue;
            return false;
        } while (!this.expensiveTransaction.compareAndSet(current, td));
        this.maxDurationInNanos = td.getRootTracer().getDuration();
        if (Agent.LOG.isLoggable(Level.FINER)) {
            String msg = MessageFormat.format("Captured named transaction trace for {0} {1}", td.getApplicationName(), td);
            Agent.LOG.finer(msg);
        }
        return true;
    }

    @Override
    public List<TransactionTrace> harvest(String appName) {
        if (this.appName != appName) {
            return Collections.emptyList();
        }
        TransactionData td = this.expensiveTransaction.get();
        if (td == FINISHED) {
            return Collections.emptyList();
        }
        if (td != null) {
            ++this.tracesSent;
        }
        if (this.shouldFinish()) {
            td = this.expensiveTransaction.getAndSet(FINISHED);
            this.stop();
        } else if (td != null) {
            this.maxDurationInNanos = 0L;
            td = this.expensiveTransaction.getAndSet(null);
        }
        if (td == null) {
            return Collections.emptyList();
        }
        return this.getTransactionTrace(td);
    }

    private List<TransactionTrace> getTransactionTrace(TransactionData td) {
        TransactionTrace trace = TransactionTrace.getTransactionTrace(td);
        if (Agent.LOG.isLoggable(Level.FINER)) {
            String msg = MessageFormat.format("Sending named transaction trace for {0}: {1}", td.getApplicationName(), td);
            Agent.LOG.finer(msg);
        }
        ArrayList<TransactionTrace> traces = new ArrayList<TransactionTrace>(1);
        traces.add(trace);
        return traces;
    }

    protected boolean hasTimeExpired() {
        return System.nanoTime() >= this.stopTime;
    }

    private boolean shouldFinish() {
        return this.hasTimeExpired() || this.tracesSent >= this.maxTraces;
    }

    @Override
    public void stop() {
        ServiceFactory.getTransactionTraceService().removeTransactionTraceSampler(this);
        if (Agent.LOG.isLoggable(Level.FINER)) {
            String msg = MessageFormat.format("Stopped named transaction tracing for {0}: transactions={1} max traces={2} duration={3}", this.appName, this.transactionNames, this.maxTraces, this.duration);
            Agent.LOG.finer(msg);
        }
    }

    private void start() {
        ServiceFactory.getTransactionTraceService().addTransactionTraceSampler(this);
        if (Agent.LOG.isLoggable(Level.FINER)) {
            String msg = MessageFormat.format("Started named transaction tracing for {0}: transactions={1} max traces={2} duration={3}", this.appName, this.transactionNames, this.maxTraces, this.duration);
            Agent.LOG.finer(msg);
        }
    }

    @Override
    public long getMaxDurationInNanos() {
        return this.maxDurationInNanos;
    }

    public static NamedTransactionSampler startSampler(String appName, List<String> transactionNames, int maxTraces, Double duration) {
        NamedTransactionSampler transactionSampler = new NamedTransactionSampler(appName, transactionNames, maxTraces, duration);
        transactionSampler.start();
        return transactionSampler;
    }
}

