/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.trace;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.ITransactionTracerConfig;
import com.newrelic.agent.database.SqlObfuscator;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.ISqlStatementTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.util.StackTraces;
import com.newrelic.org.json.simple.JSONArray;
import com.newrelic.org.json.simple.JSONStreamAware;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionSegment
implements JSONStreamAware {
    private static final Pattern INSERT_INTO_VALUES_STATEMENT = Pattern.compile("\\s*insert\\s+into\\s+([^\\s(,]*)\\s+values.*", 2);
    private String metricName;
    private final List<TransactionSegment> children;
    private final long entryTimestamp;
    private long exitTimestamp;
    private final Map<String, Object> tracerParameters;
    private int callCount = 1;
    private final SqlObfuscator sqlObfuscator;
    private final ITransactionTracerConfig ttConfig;
    private final ClassMethodSignature classMethodSignature;

    public TransactionSegment(ITransactionTracerConfig ttConfig, SqlObfuscator sqlObfuscator, long startTime, Tracer tracer) {
        this(ttConfig, sqlObfuscator, startTime, tracer, null);
    }

    TransactionSegment(ITransactionTracerConfig ttConfig, SqlObfuscator sqlObfuscator, long startTime, Tracer tracer, TransactionSegment childSegment) {
        this.ttConfig = ttConfig;
        this.sqlObfuscator = sqlObfuscator;
        this.metricName = TransactionSegment.getMetricName(tracer);
        if (childSegment == null) {
            int childCount = tracer.getChildren().size();
            this.children = new ArrayList<TransactionSegment>(childCount == 0 ? 16 : childCount);
        } else {
            this.children = new ArrayList<TransactionSegment>(1);
            this.children.add(childSegment);
        }
        this.entryTimestamp = tracer.getStartTimeInMilliseconds() - startTime;
        this.exitTimestamp = tracer.getEndTimeInMilliseconds() - startTime;
        this.tracerParameters = this.getParameters(tracer);
        this.classMethodSignature = tracer.getClassMethodSignature();
    }

    private Map<String, Object> getParameters(Tracer tracer) {
        Object sql;
        Map<String, Object> parameters = tracer.getParameters();
        if (tracer instanceof ISqlStatementTracer && (sql = ((ISqlStatementTracer)((Object)tracer)).getSql()) != null) {
            if (parameters.isEmpty()) {
                parameters = new HashMap<String, Object>(1);
            }
            parameters.put("sql", sql);
        }
        return parameters;
    }

    private static String getMetricName(Tracer tracer) {
        String metricName = tracer.getTransactionSegmentName();
        if (metricName == null || metricName.trim().length() == 0) {
            if (Agent.isDebugEnabled()) {
                throw new RuntimeException(MessageFormat.format("Encountered a transaction segment with an invalid metric name. {0}", tracer.getClass().getName()));
            }
            metricName = tracer.getClass().getName() + "*";
        }
        return metricName;
    }

    void setMetricName(String name) {
        this.metricName = name;
    }

    public Collection<TransactionSegment> getChildren() {
        return Collections.unmodifiableCollection(this.children);
    }

    public String getMetricName() {
        return this.metricName;
    }

    public void addChild(TransactionSegment sample) {
        try {
            this.children.add(sample);
        }
        catch (UnsupportedOperationException e) {
            String msg = MessageFormat.format("Unable to add transaction segment {0} to parent segment {1}", sample, this);
            Agent.LOG.info(msg);
        }
    }

    public String toString() {
        return this.metricName;
    }

    @Override
    public void writeJSONString(Writer writer) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>(this.tracerParameters);
        this.processSqlParams(params);
        if (this.callCount > 1) {
            params.put("call_count", this.callCount);
        }
        JSONArray.writeJSONString(Arrays.asList(this.entryTimestamp, this.exitTimestamp, this.metricName, params, this.children, this.classMethodSignature.getClassName(), this.classMethodSignature.getMethodName()), writer);
    }

    private void processSqlParams(Map<String, Object> params) {
        Object sqlObj;
        List backtrace = (List)params.remove("backtrace");
        if (backtrace != null) {
            List<StackTraceElement> stackTraces = StackTraces.scrubAndTruncate(backtrace);
            params.put("backtrace", StackTraces.toStringList(stackTraces));
        }
        if ((sqlObj = params.remove("sql")) == null) {
            return;
        }
        String sql = this.sqlObfuscator.obfuscateSql(sqlObj.toString());
        if (sql == null) {
            return;
        }
        if (INSERT_INTO_VALUES_STATEMENT.matcher(sql).matches()) {
            int maxLength = this.ttConfig.getInsertSqlMaxLength();
            sql = TransactionSegment.truncateSql(sql, maxLength);
        }
        if (this.ttConfig.isLogSql()) {
            Agent.LOG.log(Level.INFO, MessageFormat.format("{0} SQL: {1}", this.ttConfig.getRecordSql(), sql));
            return;
        }
        params.put(this.sqlObfuscator.isObfuscating() ? "sql_obfuscated" : "sql", sql);
    }

    public void merge(Tracer tracer) {
        ++this.callCount;
        this.exitTimestamp += tracer.getDurationInMilliseconds();
    }

    public static String truncateSql(String sql, int maxLength) {
        int len = sql.length();
        if (len > maxLength) {
            return MessageFormat.format("{0}..({1} more chars)", sql.substring(0, maxLength), len - maxLength);
        }
        return sql;
    }
}

