/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers;

import com.newrelic.agent.TracerService;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.TraceAnnotationInfo;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.OtherDispatcherTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.TracerFactory;
import com.newrelic.agent.tracers.metricname.ClassMethodMetricNameFormat;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;
import com.newrelic.agent.util.Strings;

public class CustomTracerFactory
implements TracerFactory {
    private final TracerFactory knownTracerFactory;
    private volatile TracerFactory customTracerFactory;
    private final TracerService tracerService = ServiceFactory.getTracerService();
    private final MetricNameFormat metricNameFormatDispatcher;
    private final MetricNameFormat metricNameFormat;
    private final String tracerFactoryName;

    public CustomTracerFactory(ClassMethodSignature classMethodSignature, TraceAnnotationInfo trace) {
        this.tracerFactoryName = trace.tracerFactoryName();
        this.knownTracerFactory = this.initializeTracerFactory(classMethodSignature, trace);
        String metricName = trace.metricName();
        if (Strings.isEmpty(metricName)) {
            metricName = null;
        }
        this.metricNameFormatDispatcher = new SimpleMetricNameFormat(metricName != null ? "OtherTransaction/Custom/" + metricName : ClassMethodMetricNameFormat.getMetricName(classMethodSignature, "OtherTransaction/Custom"));
        this.metricNameFormat = metricName != null ? new SimpleMetricNameFormat(metricName) : new SimpleMetricNameFormat(ClassMethodMetricNameFormat.getMetricName(classMethodSignature, "Custom"));
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object object, Object[] args) {
        if (this.knownTracerFactory != null) {
            return this.knownTracerFactory.getTracer(transaction, sig, object, args);
        }
        if (this.customTracerFactory == null) {
            this.customTracerFactory = this.tracerService.getTracerFactory(this.tracerFactoryName);
        }
        return this.customTracerFactory.getTracer(transaction, sig, object, args);
    }

    private TracerFactory initializeTracerFactory(ClassMethodSignature sig, TraceAnnotationInfo traceAnnotation) {
        if (!Strings.isEmpty(traceAnnotation.tracerFactoryName())) {
            return this.tracerService.getTracerFactory(traceAnnotation.tracerFactoryName());
        }
        if (traceAnnotation.dispatcher()) {
            return this.makeCustomDispatcherTracerFactory();
        }
        if (traceAnnotation.skipTransactionTrace()) {
            return this.makeCustomSkipTracerFactory();
        }
        return this.makeCustomMetricTracerFactory();
    }

    private TracerFactory makeCustomDispatcherTracerFactory() {
        return new TracerFactory(){

            public Tracer getTracer(Transaction tx, ClassMethodSignature sig, Object object, Object[] args) {
                if (tx.getRootTracer() == null) {
                    return new OtherDispatcherTracer(tx, sig, object, CustomTracerFactory.this.metricNameFormatDispatcher);
                }
                return new DefaultTracer(tx, sig, object, CustomTracerFactory.this.metricNameFormat);
            }
        };
    }

    private TracerFactory makeCustomMetricTracerFactory() {
        return new TracerFactory(){

            public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object object, Object[] args) {
                return new DefaultTracer(transaction, sig, object, CustomTracerFactory.this.metricNameFormat);
            }
        };
    }

    private TracerFactory makeCustomSkipTracerFactory() {
        return new TracerFactory(){

            public Tracer getTracer(Transaction tx, ClassMethodSignature sig, Object object, Object[] args) {
                return new CustomSkipTracer(tx, sig, object, CustomTracerFactory.this.metricNameFormat);
            }
        };
    }

    private static class CustomSkipTracer
    extends DefaultTracer {
        public CustomSkipTracer(Transaction tx, ClassMethodSignature sig, Object object, MetricNameFormat metricNameFormatter) {
            super(tx, sig, object, metricNameFormatter);
        }

        public final boolean isTransactionSegment() {
            return false;
        }
    }
}

