/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.config.ITransactionTracerConfig;
import com.newrelic.agent.database.SqlObfuscator;
import com.newrelic.agent.stats.ResponseTimeStats;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.trace.TransactionSegment;
import com.newrelic.agent.tracers.AbstractTracer;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.SkipTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTracer
extends AbstractTracer {
    private static final int INITIAL_PARAMETER_MAP_SIZE = 5;
    public static final MetricNameFormat NULL_METRIC_NAME_FORMATTER = new SimpleMetricNameFormat(null);
    private final long startTime;
    private long duration;
    private long exclusiveDuration;
    private Map<String, Object> parameters;
    private final Tracer parentTracer;
    private Throwable throwable;
    private final ClassMethodSignature classMethodSignature;
    private Object invocationTarget;
    private MetricNameFormat metricNameFormat;
    protected final boolean generateTransactionSegment;
    private final boolean metricProducer;
    private boolean isParent;

    public DefaultTracer(Transaction transaction, ClassMethodSignature sig, Object object, MetricNameFormat metricNameFormatter, int tracerFlags) {
        super(transaction);
        this.metricNameFormat = metricNameFormatter;
        this.classMethodSignature = sig;
        this.startTime = System.nanoTime();
        this.invocationTarget = object;
        this.parentTracer = transaction.getLastTracer();
        this.generateTransactionSegment = transaction.shouldGenerateTransactionSegment() && (tracerFlags & 8) > 0;
        this.metricProducer = (tracerFlags & 6) > 0;
    }

    public DefaultTracer(Transaction transaction, ClassMethodSignature sig, Object object, MetricNameFormat metricNameFormatter) {
        this(transaction, sig, object, metricNameFormatter, 10);
    }

    public DefaultTracer(Transaction transaction, ClassMethodSignature sig, Object object) {
        this(transaction, sig, object, NULL_METRIC_NAME_FORMATTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void finish(Throwable throwable) {
        this.throwable = throwable;
        try {
            this.transaction.lockTracerStart();
            this.doFinish(throwable);
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("An error occurred finishing tracer for class {0} : {1}", this.classMethodSignature.getClassName(), t);
            if (Agent.LOG.isLoggable(Level.FINER)) {
                Agent.LOG.log(Level.WARNING, msg, t);
            } else {
                Agent.LOG.warning(msg);
            }
        }
        finally {
            this.transaction.unlockTracerStart();
        }
        this.finish(191, null);
        if (Agent.isDebugEnabled()) {
            Agent.LOG.log(Level.FINE, "(Debug) Tracer.finish(Throwable)");
        }
    }

    protected void reset() {
        this.invocationTarget = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void finish(int opcode, Object returnValue) {
        String msg;
        this.duration = Math.max(0L, System.nanoTime() - this.startTime);
        this.exclusiveDuration += this.duration;
        if (this.exclusiveDuration < 0L || this.exclusiveDuration > this.duration) {
            String msg2 = MessageFormat.format("Invalid exclusive time {0} for tracer {1}", this.exclusiveDuration, this.getClass().getName());
            Agent.LOG.severe(msg2);
            this.exclusiveDuration = this.duration;
        }
        try {
            this.transaction.lockTracerStart();
            if (191 != opcode) {
                this.doFinish(opcode, returnValue);
            }
        }
        catch (Throwable t) {
            msg = MessageFormat.format("An error occurred finishing tracer for class {0} : {1}", this.classMethodSignature.getClassName(), t.toString());
            Agent.LOG.severe(msg);
            Agent.LOG.log(Level.FINER, msg, t);
        }
        finally {
            this.transaction.unlockTracerStart();
        }
        if (this.parentTracer != null) {
            this.parentTracer.childTracerFinished(this);
        }
        try {
            this.recordMetrics(this.transaction.getTransactionStats());
        }
        catch (Throwable t) {
            msg = MessageFormat.format("An error occurred recording tracer metrics for class {0} : {1}", this.classMethodSignature.getClassName(), t.toString());
            Agent.LOG.severe(msg);
            Agent.LOG.log(Level.FINER, msg, t);
        }
        try {
            if (!(this instanceof SkipTracer)) {
                this.transaction.tracerFinished(this, opcode);
            }
        }
        catch (Throwable t) {
            msg = MessageFormat.format("An error occurred calling Transaction.tracerFinished() for class {0} : {1}", this.classMethodSignature.getClassName(), t.toString());
            Agent.LOG.severe(msg);
            Agent.LOG.log(Level.FINER, msg, t);
        }
        this.reset();
    }

    protected void doFinish(Throwable throwable) {
    }

    protected void doFinish(int opcode, Object returnValue) {
    }

    protected void put(String key, Object value) {
        if (this.parameters == null) {
            if (this.transaction.isOverTracerSegmentLimit()) {
                return;
            }
            this.parameters = new HashMap<String, Object>(1, 5.0f);
        }
        if (value.getClass().isArray()) {
            value = Arrays.asList((Object[])value);
        }
        this.transaction.incrementSize(DefaultTracer.sizeof(value));
        this.parameters.put(key, value);
    }

    static int sizeof(Object value) {
        int size = 0;
        if (value == null) {
            return 0;
        }
        if (value instanceof String) {
            return ((String)value).length();
        }
        if (value instanceof StackTraceElement) {
            StackTraceElement elem = (StackTraceElement)value;
            return DefaultTracer.sizeof(elem.getClassName()) + DefaultTracer.sizeof(elem.getFileName()) + DefaultTracer.sizeof(elem.getMethodName()) + 10;
        }
        if (value instanceof Object[]) {
            for (Object obj : (Object[])value) {
                size += DefaultTracer.sizeof(obj);
            }
        }
        return size;
    }

    @Override
    public Map<String, Object> getParameters() {
        if (this.parameters == null) {
            return Collections.emptyMap();
        }
        return this.parameters;
    }

    @Override
    public long getDurationInMilliseconds() {
        return TimeUnit.MILLISECONDS.convert(this.getDuration(), TimeUnit.NANOSECONDS);
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public long getExclusiveDuration() {
        return this.exclusiveDuration;
    }

    @Override
    public long getEndTime() {
        return this.startTime + this.duration;
    }

    @Override
    public long getEndTimeInMilliseconds() {
        return TimeUnit.MILLISECONDS.convert(this.getEndTime(), TimeUnit.NANOSECONDS);
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getStartTimeInMilliseconds() {
        return TimeUnit.MILLISECONDS.convert(this.getStartTime(), TimeUnit.NANOSECONDS);
    }

    protected final Object getInvocationTarget() {
        return this.invocationTarget;
    }

    @Override
    public Tracer getParentTracer() {
        return this.parentTracer;
    }

    public String getRequestMetricName() {
        return null;
    }

    protected final void setMetricNameFormat(MetricNameFormat nameFormat) {
        this.metricNameFormat = nameFormat;
    }

    protected final MetricNameFormat getMetricNameFormat() {
        return this.metricNameFormat;
    }

    @Override
    public final String getMetricName() {
        return this.metricNameFormat == null ? null : this.metricNameFormat.getMetricName();
    }

    @Override
    public final String getTransactionSegmentName() {
        return this.metricNameFormat == null ? null : this.metricNameFormat.getTransactionSegmentName();
    }

    @Override
    public Throwable getThrowable() {
        return this.throwable;
    }

    protected void recordMetrics(TransactionStats transactionStats) {
        if (this.transaction.isIgnore()) {
            return;
        }
        if (this.isMetricProducer()) {
            String metricName = this.getMetricName();
            if (metricName != null) {
                ResponseTimeStats stats = transactionStats.getScopedStats().getResponseTimeStats(metricName);
                stats.recordResponseTimeInNanos(this.getDuration(), this.getExclusiveDuration());
            }
            this.doRecordMetrics(transactionStats);
        }
    }

    protected void doRecordMetrics(TransactionStats transactionStats) {
    }

    protected final boolean isParent() {
        return this.isParent;
    }

    public List<Tracer> getChildren() {
        if (this.isParent) {
            ArrayList<Tracer> kids = new ArrayList<Tracer>();
            for (Tracer tracer : this.transaction.getTracers()) {
                if (this != tracer.getParentTracer()) continue;
                kids.add(tracer);
            }
            return kids;
        }
        return Collections.emptyList();
    }

    @Override
    public void childTracerFinished(Tracer child) {
        if (child.isMetricProducer() && !(child instanceof SkipTracer)) {
            this.exclusiveDuration -= child.getDuration();
            if (this.generateTransactionSegment && child.isTransactionSegment()) {
                this.isParent = true;
            }
        }
    }

    @Override
    public ClassMethodSignature getClassMethodSignature() {
        return this.classMethodSignature;
    }

    @Override
    public boolean isTransactionSegment() {
        return this.generateTransactionSegment;
    }

    @Override
    public boolean isMetricProducer() {
        return this.metricProducer;
    }

    @Override
    public TransactionSegment getTransactionSegment(ITransactionTracerConfig ttConfig, SqlObfuscator sqlObfuscator, long startTime, TransactionSegment lastSibling) {
        return new TransactionSegment(ttConfig, sqlObfuscator, startTime, this);
    }
}

