/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.application.RemoteApplicationInfo;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.IgnoreChildSocketCalls;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;
import com.newrelic.agent.util.Strings;
import java.util.concurrent.TimeUnit;

public class ExternalComponentTracer
extends DefaultTracer
implements IgnoreChildSocketCalls {
    public static final String NEWRELIC_ID_HEADER_KEY = "X-NewRelic-ID";
    public static final String NEWRELIC_TRANSACTION_NAME_HEADER_KEY = "X-NewRelic-Name";
    public static final String NEWRELIC_GUID_HEADER_KEY = "X-NewRelic-Guid";
    private String host;
    private int responseStatusCode;

    public ExternalComponentTracer(Transaction transaction, ClassMethodSignature sig, Object object, String host, String library, String ... operations) {
        this(transaction, sig, object, host, library, false, operations);
    }

    public ExternalComponentTracer(Transaction transaction, ClassMethodSignature sig, Object object, String host, String library, boolean includeOperationInMetric, String ... operations) {
        super(transaction, sig, object, ExternalComponentTracer.getMetricNameFormat(host, library, includeOperationInMetric, operations));
        this.host = host;
    }

    public ExternalComponentTracer(Transaction transaction, ClassMethodSignature sig, Object object, String host, String library) {
        super(transaction, sig, object, ExternalComponentTracer.getMetricNameFormat(host, library));
        this.host = host;
    }

    public ExternalComponentTracer(Transaction transaction, ClassMethodSignature sig, Object object, MetricNameFormatWithHost metricNameFormat) {
        super(transaction, sig, object, metricNameFormat);
        this.host = metricNameFormat.getHost();
    }

    public static MetricNameFormatWithHost getMetricNameFormat(String host, String library) {
        return new MetricNameFormatWithHost(host, library);
    }

    public static MetricNameFormat getMetricNameFormat(String host, String library, boolean includeOperationInMetric, String ... operations) {
        return new ExternalComponentNameFormat(host, library, includeOperationInMetric, operations);
    }

    protected void doFinish(int opcode, Object returnValue) {
        super.doFinish(opcode, returnValue);
        this.recordResponseStatusCode(returnValue);
    }

    protected void recordResponseStatusCode(Object returnValue) {
    }

    protected String getHeaderValue(Object returnValue, String name) {
        return null;
    }

    void setRemoteAppInfo(RemoteApplicationInfo remoteApplicationInfo) {
    }

    protected void doRecordMetrics(TransactionStats transactionStats) {
        transactionStats.getUnscopedStats().getResponseTimeStats("External/all").recordResponseTime(this.getExclusiveDuration(), TimeUnit.NANOSECONDS);
        transactionStats.getUnscopedStats().getResponseTimeStats(this.transaction.isWebTransaction() ? "External/allWeb" : "External/allOther").recordResponseTime(this.getExclusiveDuration(), TimeUnit.NANOSECONDS);
        transactionStats.getUnscopedStats().getResponseTimeStats(Strings.join('/', "External", this.host, "all")).recordResponseTime(this.getExclusiveDuration(), TimeUnit.NANOSECONDS);
    }

    protected void setResponseStatusCode(int statusCode) {
        this.responseStatusCode = statusCode;
    }

    private static class ExternalComponentNameFormat
    implements MetricNameFormatWithServer {
        private String metricName;
        private String transactionSegmentName;
        private String[] operations;
        private String server = "Server";
        private boolean includeOperationInMetric;
        private final String host;
        private final String library;

        public ExternalComponentNameFormat(String host, String library, boolean includeOperationInMetric, String[] operations) {
            this.host = host;
            this.library = library;
            this.operations = operations;
            this.includeOperationInMetric = includeOperationInMetric;
            this.setMetricName();
        }

        private void setMetricName() {
            this.metricName = Strings.join('/', "External", this.host, this.library);
            if (this.includeOperationInMetric) {
                this.transactionSegmentName = this.metricName = this.metricName + this.fixOperations(this.operations);
            }
        }

        public String getMetricName() {
            return this.metricName;
        }

        public String getTransactionSegmentName() {
            if (this.transactionSegmentName == null) {
                this.transactionSegmentName = this.metricName + this.fixOperations(this.operations);
            }
            return this.transactionSegmentName;
        }

        private String fixOperations(String[] operations) {
            StringBuilder builder = new StringBuilder();
            for (String operation : operations) {
                if (operation.startsWith("/")) {
                    builder.append(operation);
                    continue;
                }
                builder.append('/').append(operation);
            }
            return builder.toString();
        }

        public void setServer(String server) {
            this.server = server;
            this.setMetricName();
        }
    }

    public static class MetricNameFormatWithHost
    implements MetricNameFormatWithServer {
        private final String host;
        private String server = "Server";
        private String metricName;
        private final String library;

        public MetricNameFormatWithHost(String host, String library) {
            this.host = host;
            this.library = library;
            this.setMetricName();
        }

        private void setMetricName() {
            this.metricName = Strings.join('/', "External", this.host, this.library);
        }

        protected final String getHost() {
            return this.host;
        }

        public void setServer(String server) {
            this.server = server;
            this.setMetricName();
        }

        public String getMetricName() {
            return this.metricName;
        }

        public String getTransactionSegmentName() {
            return this.metricName;
        }
    }

    private static interface MetricNameFormatWithServer
    extends MetricNameFormat {
        public void setServer(String var1);
    }
}

