/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers;

import com.newrelic.agent.Agent;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.application.RemoteApplicationInfo;
import com.newrelic.agent.config.ITransactionTracerConfig;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.servlet.ServletService;
import com.newrelic.agent.stats.ApdexStats;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.tracers.Dispatcher;
import com.newrelic.agent.tracers.servlet.ExternalTimeTracker;
import com.newrelic.agent.tracers.servlet.HttpRequest;
import com.newrelic.agent.tracers.servlet.HttpResponse;
import com.newrelic.agent.transaction.PriorityTransactionName;
import com.newrelic.agent.transaction.TransactionNameListener;
import com.newrelic.agent.transaction.TransactionNamer;
import com.newrelic.agent.transaction.UnmodifiableTransactionNameException;
import com.newrelic.agent.transaction.WebTransactionNamer;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class WebRequestDispatcher
implements Dispatcher {
    private static final String UNKNOWN_URI = "/Unknown";
    private HttpRequest request;
    private HttpResponse response;
    private final Transaction transaction;
    private String requestURI;
    private boolean ignoreApdex = false;
    private final ExternalTimeTracker externalTimeTracker;
    private String incomingEncodedAppInfo;

    public WebRequestDispatcher(HttpRequest request, HttpResponse response, Transaction transaction) {
        this.request = request;
        this.response = response;
        this.transaction = transaction;
        this.externalTimeTracker = ExternalTimeTracker.create(request, transaction.getStartTime());
        if (null != request) {
            String incomingGuid;
            this.incomingEncodedAppInfo = request.getHeader("X-NewRelic-ID");
            if (this.incomingEncodedAppInfo != null) {
                Agent.LOG.finest("Reading New Relic headers from an http request");
                this.sendApplicationInformation(response, transaction);
                transaction.getParameters().put("referring_account_app_id", this.incomingEncodedAppInfo);
            }
            if ((incomingGuid = request.getHeader("X-NewRelic-Guid")) != null) {
                String guid = transaction.getGuidString(true);
                if (guid != null) {
                    response._nr_setHeader("X-NewRelic-Guid", guid);
                }
                transaction.getParameters().put("referring_guid", incomingGuid);
            }
        }
    }

    private void sendApplicationInformation(final HttpResponse response, Transaction transaction) {
        IRPMService rpmService = transaction.getRPMService();
        String appId = rpmService.getApplicationIdentifier();
        if (null != appId) {
            response._nr_setHeader("X-NewRelic-ID", appId);
            transaction.setTransactionNameListener(new TransactionNameListener(){

                public void noticeTransactionName(PriorityTransactionName transactionName) throws UnmodifiableTransactionNameException {
                    String encodedTransactionName;
                    try {
                        encodedTransactionName = RemoteApplicationInfo.obfuscateTransactionName(transactionName.getName());
                    }
                    catch (UnsupportedEncodingException e) {
                        Agent.LOG.log(Level.FINER, "Unable to encode transaction name", e);
                        return;
                    }
                    try {
                        response._nr_setHeader("X-NewRelic-Name", encodedTransactionName);
                        Agent.LOG.finest("Added the transaction name to the http response headers");
                    }
                    catch (Exception ex) {
                        Agent.LOG.log(Level.FINEST, "Unable to add the transaction name to the http response headers", ex);
                        throw new UnmodifiableTransactionNameException(ex);
                    }
                }
            });
        }
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpRequest request) {
        this.request = request;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public void setResponse(HttpResponse response) {
        this.response = response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transactionFinished(String transactionName) {
        if (this.request != null) {
            try {
                this.doRecordMetrics(transactionName);
                if (this.transaction.isInteresting()) {
                    this.recordParameters();
                    this.storeReferrer();
                }
            }
            finally {
                this.request = null;
                this.response = null;
            }
        }
    }

    public final String getUri() {
        if (this.requestURI == null) {
            this.requestURI = this.initializeRequestURI();
        }
        return this.requestURI;
    }

    public void setTransactionName() {
        this.storeResponseStatus();
        TransactionNamer tn = WebTransactionNamer.create(this.transaction, this.getUri());
        tn.setTransactionName();
    }

    private String initializeRequestURI() {
        String result = null;
        try {
            String uri = this.request.getRequestURI();
            if (uri == null || uri.length() == 0) {
                result = UNKNOWN_URI;
                String msg = MessageFormat.format("requestURI is null: setting requestURI to {0}", result);
                if (Agent.LOG.isLoggable(Level.FINER)) {
                    Agent.LOG.finer(msg);
                }
            } else {
                result = ServiceFactory.getNormalizationService().getUrlBeforeParameters(uri);
            }
        }
        catch (Throwable e) {
            Agent.LOG.severe("Error calling requestURI: " + e.getMessage());
            Agent.LOG.log(Level.FINER, e.getMessage(), e);
            result = UNKNOWN_URI;
        }
        return result;
    }

    private final void recordParameters() {
        try {
            ServletService servletService = ServiceFactory.getServletService();
            servletService.recordParameters(this.transaction, this.request);
        }
        catch (Throwable e) {
            Agent.LOG.log(Level.FINE, "Unable to capture request parameters", e);
        }
    }

    private void storeReferrer() {
        try {
            String referer = this.request.getHeader("Referer");
            if (referer != null) {
                this.transaction.getParameters().put("request_referer", referer);
            }
        }
        catch (Throwable e) {
            Agent.LOG.fine("Error getting referer: " + e.getMessage());
            Agent.LOG.log(Level.FINER, e.getMessage(), e);
        }
    }

    private void storeResponseStatus() {
        try {
            int status = this.response._nr_getResponseStatus();
            this.transaction.setStatus(status);
            if (status >= 400) {
                this.transaction.setStatusMessage(this.response._nr_getResponseStatusMessage());
            }
        }
        catch (Exception e) {
            Agent.LOG.finest(e.getMessage());
        }
    }

    public boolean isIgnoreApdex() {
        return this.ignoreApdex;
    }

    public final void setIgnoreApdex(boolean ignore) {
        this.ignoreApdex = ignore;
    }

    private void doRecordMetrics(String transactionName) {
        this.recordHeaderMetrics(this.transaction.getTransactionStats());
        this.recordApdexMetrics(transactionName);
        this.recordDispatcherMetrics(transactionName);
        if (this.incomingEncodedAppInfo != null) {
            String metricName = MessageFormat.format("ClientApplication/{0}/all", this.incomingEncodedAppInfo);
            this.transaction.getTransactionStats().getUnscopedStats().getResponseTimeStats(metricName).recordResponseTime(this.transaction.getRootTracer().getDuration(), TimeUnit.NANOSECONDS);
        }
    }

    public void recordHeaderMetrics(TransactionStats statsEngine) {
        this.externalTimeTracker.recordMetrics(statsEngine);
    }

    public long getQueueTime() {
        return this.externalTimeTracker.getExternalTime();
    }

    private void recordDispatcherMetrics(String frontendMetricName) {
        if (frontendMetricName == null || frontendMetricName.length() == 0) {
            return;
        }
        TransactionStats stats = this.transaction.getTransactionStats();
        long frontendTimeInNanos = this.transaction.getRootTracer().getDuration();
        stats.getUnscopedStats().getResponseTimeStats(frontendMetricName).recordResponseTimeInNanos(frontendTimeInNanos, 0L);
        stats.getUnscopedStats().getResponseTimeStats("WebTransaction").recordResponseTimeInNanos(frontendTimeInNanos);
        stats.getUnscopedStats().getResponseTimeStats("HttpDispatcher").recordResponseTimeInNanos(frontendTimeInNanos);
    }

    private void recordApdexMetrics(String frontendMetricName) {
        if (frontendMetricName == null || frontendMetricName.length() == 0) {
            return;
        }
        if (!this.transaction.getAgentConfig().isApdexTSet()) {
            return;
        }
        if (this.ignoreApdex) {
            if (Agent.LOG.isLoggable(Level.FINE)) {
                String msg = MessageFormat.format("Ignoring transaction for apdex {0}", frontendMetricName);
                Agent.LOG.log(Level.FINE, msg);
            }
            return;
        }
        String frontendApdexMetricName = this.getFrontendApdexMetricName(frontendMetricName);
        if (frontendApdexMetricName == null || frontendApdexMetricName.length() == 0) {
            return;
        }
        String partialName = this.transaction.getPriorityTransactionName().getPartialName();
        long apdexT = this.transaction.getAgentConfig().getApdexTInMillis(partialName);
        ApdexStats apdexStats = this.transaction.getTransactionStats().getUnscopedStats().getApdexStats(frontendApdexMetricName);
        ApdexStats overallApdexStats = this.transaction.getTransactionStats().getUnscopedStats().getApdexStats("Apdex");
        if (this.isApdexFrustrating()) {
            apdexStats.recordApdexFrustrated();
            overallApdexStats.recordApdexFrustrated();
        } else {
            long responseTimeInMillis = this.transaction.getRootTracer().getDurationInMilliseconds() + this.externalTimeTracker.getExternalTime();
            apdexStats.recordApdexResponseTime(responseTimeInMillis, apdexT);
            overallApdexStats.recordApdexResponseTime(responseTimeInMillis, apdexT);
        }
    }

    private String getFrontendApdexMetricName(String blameMetricName) {
        if (blameMetricName != null && blameMetricName.indexOf("WebTransaction") == 0) {
            return "Apdex" + blameMetricName.substring("WebTransaction".length());
        }
        return null;
    }

    public boolean isApdexFrustrating() {
        String appName = this.transaction.getPriorityApplicationName().getName();
        IRPMService rpmService = ServiceFactory.getRPMService(appName);
        return this.transaction.getStatus() >= 400 && !rpmService.getErrorService().isIgnoredError(this.transaction.getStatus(), this.transaction.getReportError());
    }

    public ITransactionTracerConfig getTransactionTracerConfig() {
        return this.transaction.getAgentConfig().getRequestTransactionTracerConfig();
    }

    public boolean isWebTransaction() {
        return true;
    }

    public String getCookieValue(String name) {
        if (this.request == null) {
            return null;
        }
        return this.request.getCookieValue(name);
    }

    public String getHeader(String name) {
        if (this.request == null) {
            return null;
        }
        return this.request.getHeader(name);
    }

    public Transaction getTransaction() {
        return this.transaction;
    }
}

