/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers.jasper;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.tracers.jasper.AbstractRUMState;
import com.newrelic.agent.tracers.jasper.GenerateVisitor;
import com.newrelic.agent.tracers.jasper.RUMState;
import com.newrelic.agent.tracers.jasper.TemplateText;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ScriptState
extends AbstractRUMState {
    private static final Pattern START_SCRIPT_PATTERN = Pattern.compile("<script", 34);
    private static final Pattern END_SCRIPT_PATTERN = Pattern.compile("</script>", 34);
    private RUMState delegate;
    private boolean startScriptFound;

    public ScriptState(RUMState delegate) {
        this.delegate = delegate;
    }

    public RUMState process(Transaction tx, GenerateVisitor generator, TemplateText node, String text) throws Exception {
        while (text != null) {
            if (this.startScriptFound) {
                text = this.script(tx, generator, node, text);
                continue;
            }
            text = this.noScript(tx, generator, node, text);
        }
        return this;
    }

    private String noScript(Transaction tx, GenerateVisitor generator, TemplateText node, String text) throws Exception {
        Matcher matcher = START_SCRIPT_PATTERN.matcher(text);
        if (matcher.find()) {
            this.startScriptFound = true;
            String beforeScript = text.substring(0, matcher.start());
            this.delegate = this.delegate.process(tx, generator, node, beforeScript);
            return text.substring(matcher.start(), text.length());
        }
        this.delegate = this.delegate.process(tx, generator, node, text);
        return null;
    }

    private String script(Transaction tx, GenerateVisitor generator, TemplateText node, String text) throws Exception {
        Matcher matcher = END_SCRIPT_PATTERN.matcher(text);
        if (matcher.find()) {
            this.startScriptFound = false;
            String before = text.substring(0, matcher.end());
            this.writeText(tx, generator, node, before);
            return text.substring(matcher.end(), text.length());
        }
        this.writeText(tx, generator, node, text);
        return null;
    }
}

