/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers.servlet;

import com.newrelic.agent.Agent;
import com.newrelic.agent.tracers.servlet.AsyncContextNr;
import com.newrelic.agent.tracers.servlet.Cookie;
import com.newrelic.agent.tracers.servlet.HttpRequest;
import com.newrelic.agent.tracers.servlet.HttpServletRequest;
import com.newrelic.agent.tracers.servlet.HttpServletRequestExtension;
import com.newrelic.agent.tracers.servlet.ServletRequest30;
import com.newrelic.agent.tracers.servlet.ServletRequest30Extension;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDelegatingServletHttpRequest
implements HttpRequest {
    private static final String COOKIE_HEADER_NAME = "Cookie";
    private static final String COOKIE_HEADER_REGEX = "([^\\s;=]+)=([^;]*)";
    private static final Pattern COOKIE_HEADER_PATTERN = Pattern.compile("([^\\s;=]+)=([^;]*)");

    protected AbstractDelegatingServletHttpRequest() {
    }

    protected abstract HttpServletRequest getDelegate();

    protected abstract HttpServletRequestExtension getExtensionDelegate();

    protected abstract ServletRequest30 getDelegate30();

    protected abstract ServletRequest30Extension getExtensionDelegate30();

    @Override
    public boolean isAsyncSupported() {
        ServletRequest30 delegate = this.getDelegate30();
        if (delegate == null) {
            return false;
        }
        try {
            return delegate.isAsyncSupported();
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("Exception in {0}.isAsyncSupported(): {1}", delegate.getClass().getName(), t);
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                Agent.LOG.log(Level.FINEST, msg);
            }
            return false;
        }
    }

    @Override
    public boolean isAsyncStarted() {
        ServletRequest30 delegate = this.getDelegate30();
        if (delegate == null) {
            return false;
        }
        try {
            return delegate.isAsyncStarted();
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("Exception in {0}.isAsyncStarted(): {1}", delegate.getClass().getName(), t);
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                Agent.LOG.log(Level.FINEST, msg);
            }
            return false;
        }
    }

    @Override
    public AsyncContextNr getAsyncContextNr() {
        ServletRequest30Extension delegate = this.getExtensionDelegate30();
        if (delegate == null) {
            return null;
        }
        try {
            Object asyncContext = delegate._nr_getAsyncContext();
            if (asyncContext instanceof AsyncContextNr) {
                return (AsyncContextNr)asyncContext;
            }
            return null;
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("Exception in {0}.getAsyncContextNr(): {1}", delegate.getClass().getName(), t);
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                Agent.LOG.log(Level.FINEST, msg);
            }
            return null;
        }
    }

    @Override
    public Enumeration<?> getParameterNames() {
        HttpServletRequest delegate = null;
        try {
            delegate = this.getDelegate();
            if (delegate == null) {
                return null;
            }
            return delegate.getParameterNames();
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Exception in {0}.getParameterNames(): {1}", delegate.getClass().getName(), e);
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                Agent.LOG.log(Level.FINEST, msg, e);
            } else if (Agent.LOG.isLoggable(Level.FINER)) {
                Agent.LOG.finer(msg);
            }
            return null;
        }
    }

    @Override
    public String[] getParameterValues(String name) {
        HttpServletRequest delegate = null;
        try {
            delegate = this.getDelegate();
            if (delegate == null) {
                return null;
            }
            return delegate.getParameterValues(name);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Exception in {0}.getParameterValues(String): {1}", delegate.getClass().getName(), e);
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                Agent.LOG.log(Level.FINEST, msg, e);
            } else if (Agent.LOG.isLoggable(Level.FINER)) {
                Agent.LOG.finer(msg);
            }
            return null;
        }
    }

    @Override
    public Object getAttribute(String name) {
        HttpServletRequest delegate = null;
        try {
            delegate = this.getDelegate();
            if (delegate == null) {
                return null;
            }
            return delegate.getAttribute(name);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Exception in {0}.getAttribute(String): {1}", delegate.getClass().getName(), e);
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                Agent.LOG.log(Level.FINEST, msg, e);
            } else if (Agent.LOG.isLoggable(Level.FINER)) {
                Agent.LOG.finer(msg);
            }
            return null;
        }
    }

    @Override
    public String getRequestURI() {
        HttpServletRequest delegate = null;
        try {
            delegate = this.getDelegate();
            if (delegate == null) {
                return null;
            }
            return delegate.getRequestURI();
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Exception in {0}.getRequestURI(): {1}", delegate.getClass().getName(), e);
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                Agent.LOG.log(Level.FINEST, msg, e);
            } else if (Agent.LOG.isLoggable(Level.FINER)) {
                Agent.LOG.finer(msg);
            }
            return null;
        }
    }

    @Override
    public String getHeader(String name) {
        HttpServletRequest delegate = null;
        try {
            delegate = this.getDelegate();
            if (delegate == null) {
                return null;
            }
            return delegate.getHeader(name);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Exception in {0}.getHeader(String): {1}", delegate.getClass().getName(), e);
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                Agent.LOG.log(Level.FINEST, msg, e);
            } else if (Agent.LOG.isLoggable(Level.FINER)) {
                Agent.LOG.finer(msg);
            }
            return null;
        }
    }

    @Override
    public String getRemoteUser() {
        HttpServletRequest delegate = null;
        try {
            delegate = this.getDelegate();
            if (delegate == null) {
                return null;
            }
            return delegate.getRemoteUser();
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Exception in {0}.getRemoteUser(): {1}", delegate.getClass().getName(), e);
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                Agent.LOG.log(Level.FINEST, msg, e);
            } else if (Agent.LOG.isLoggable(Level.FINER)) {
                Agent.LOG.finer(msg);
            }
            return null;
        }
    }

    @Override
    public String getCookieValue(String name) {
        HttpServletRequestExtension extensionDelegate = this.getExtensionDelegate();
        if (extensionDelegate != null) {
            return this.getCookieValueFromCookie(extensionDelegate, name);
        }
        return this.getCookieValueFromHeader(name);
    }

    private String getCookieValueFromCookie(HttpServletRequestExtension extensionDelegate, String name) {
        try {
            return this.getCookieValueFromCookie2(extensionDelegate, name);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Exception in {0}.getCookieValue(String): {1}", extensionDelegate.getClass().getName(), e);
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                Agent.LOG.log(Level.FINEST, msg, e);
            } else if (Agent.LOG.isLoggable(Level.FINER)) {
                Agent.LOG.finer(msg);
            }
            return null;
        }
    }

    private String getCookieValueFromCookie2(HttpServletRequestExtension extensionDelegate, String name) {
        Object[] cookies = extensionDelegate._nr_getCookies();
        if (cookies == null) {
            return null;
        }
        for (int i = 0; i < cookies.length; ++i) {
            Cookie cookie;
            if (!(cookies[i] instanceof Cookie) || !(cookie = (Cookie)cookies[i]).getName().equals(name)) continue;
            return cookie.getValue();
        }
        return null;
    }

    private String getCookieValueFromHeader(String name) {
        try {
            return this.getCookieValueFromHeader2(name);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Exception getting cookie value from header: {0}", e);
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                Agent.LOG.log(Level.FINEST, msg, e);
            } else if (Agent.LOG.isLoggable(Level.FINER)) {
                Agent.LOG.finer(msg);
            }
            return null;
        }
    }

    private String getCookieValueFromHeader2(String name) {
        if (name == null) {
            return null;
        }
        String cookieHeader = this.getHeader(COOKIE_HEADER_NAME);
        if (cookieHeader == null) {
            return null;
        }
        Matcher matcher = COOKIE_HEADER_PATTERN.matcher(cookieHeader);
        while (matcher.find()) {
            String cookieName = matcher.group(1);
            if (!name.equals(cookieName)) continue;
            return matcher.group(2);
        }
        return null;
    }
}

