/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers.servlet;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.tracers.servlet.AsyncContextNr;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.logging.Level;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;

public class AsyncListenerImpl
implements AsyncListener {
    public void onComplete(AsyncEvent arg0) throws IOException {
        Agent.LOG.finer("OnComplete");
        AsyncContextNr asyncContext = this.getAsyncContext(arg0);
        Transaction tx = (Transaction)asyncContext._nr_getTransaction();
        if (tx != null) {
            tx.getTransactionState().complete();
        }
    }

    public void onTimeout(AsyncEvent arg0) throws IOException {
        Agent.LOG.finer("OnTimeout");
        AsyncContextNr asyncContext = this.getAsyncContext(arg0);
        Transaction tx = (Transaction)asyncContext._nr_getTransaction();
        if (tx == null) {
            return;
        }
        tx.setStatus(500);
        tx.setStatusMessage("Async timeout event");
    }

    public void onError(AsyncEvent arg0) throws IOException {
        AsyncContextNr asyncContext = this.getAsyncContext(arg0);
        Transaction tx = (Transaction)asyncContext._nr_getTransaction();
        if (tx == null) {
            return;
        }
        Throwable t = arg0.getThrowable();
        if (t == null) {
            return;
        }
        tx.setThrowable(t);
        if (Agent.LOG.isLoggable(Level.FINER)) {
            String msg = MessageFormat.format("OnError AsyncEvent: {0}", t);
            Agent.LOG.finer(msg);
        }
    }

    public void onStartAsync(AsyncEvent arg0) throws IOException {
        Agent.LOG.finer("OnStartAsync");
    }

    private AsyncContextNr getAsyncContext(AsyncEvent arg0) {
        AsyncContext ac = arg0.getAsyncContext();
        if (ac instanceof AsyncContextNr) {
            return (AsyncContextNr)ac;
        }
        return null;
    }
}

