/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers.servlet;

import com.newrelic.agent.Agent;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.tracers.servlet.HttpRequest;
import com.newrelic.agent.tracers.servlet.QueueTimeTracker;
import com.newrelic.agent.tracers.servlet.ServerTimeTracker;
import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class ExternalTimeTracker {
    private final QueueTimeTracker queueTimeTracker;
    private final ServerTimeTracker serverTimeTracker;
    private final long externalTime;

    private ExternalTimeTracker(HttpRequest httpRequest, long txStartTimeInMillis) {
        if (httpRequest == null) {
            Agent.LOG.finer("Unable to get headers: HttpRequest is null");
        }
        this.queueTimeTracker = QueueTimeTracker.create(httpRequest, txStartTimeInMillis);
        long queueTime = this.queueTimeTracker.getQueueTime();
        this.serverTimeTracker = ServerTimeTracker.create(httpRequest, txStartTimeInMillis, queueTime);
        long serverTime = this.serverTimeTracker.getServerTime();
        this.externalTime = TimeUnit.MILLISECONDS.convert(queueTime + serverTime, TimeUnit.MICROSECONDS);
    }

    public long getExternalTime() {
        return this.externalTime;
    }

    public void recordMetrics(TransactionStats statsEngine) {
        this.queueTimeTracker.recordMetrics(statsEngine);
        this.serverTimeTracker.recordMetrics(statsEngine);
    }

    protected static String getRequestHeader(HttpRequest httpRequest, String headerName) {
        if (httpRequest == null) {
            return null;
        }
        try {
            String header = httpRequest.getHeader(headerName);
            if (header != null && Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Got {0} header: {1}", headerName, header);
                Agent.LOG.finer(msg);
            }
            return header;
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("Error getting {0} header: {1}", headerName, t.toString());
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                Agent.LOG.log(Level.FINEST, msg, t);
            } else {
                Agent.LOG.finer(msg);
            }
            return null;
        }
    }

    public static ExternalTimeTracker create(HttpRequest httpRequest, long txStartTimeInMillis) {
        return new ExternalTimeTracker(httpRequest, txStartTimeInMillis);
    }
}

