/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers.servlet;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.application.ApplicationNameUtils;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.servlet.ServletService;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.ErrorReportingTracer;
import com.newrelic.agent.tracers.metricname.ClassMethodMetricNameFormat;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;
import com.newrelic.agent.transaction.HigherPriorityTransactionNamingPolicy;
import com.newrelic.agent.transaction.TransactionNamePriority;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.regex.Pattern;

public class JspServletTracer
extends ErrorReportingTracer {
    public static final String JSP_CATEGORY = "JSP";
    private static final String ORG_APACHE_JSP = "org.apache.jsp.";
    private static final Pattern JSP_PATTERN = Pattern.compile("_jsp$");
    private static final Pattern WEB_INF_PATTERN = Pattern.compile("WEB_002dINF");
    private static final String STATUS_CODE_ATTRIBUTE = "javax.servlet.error.status_code";
    private static final String EXCEPTION_ATTRIBUTE = "javax.servlet.jsp.jspException";

    public JspServletTracer(PointCut pc, Transaction tx, ClassMethodSignature sig, Object servlet, Object[] args) {
        super(tx, sig, servlet);
        Object request = args[0];
        try {
            int statusCode;
            ServletService servletService = ServiceFactory.getServletService();
            Object status = servletService.getAttributeForServletRequest(request, STATUS_CODE_ATTRIBUTE);
            int n = statusCode = status == null ? 200 : Integer.parseInt(status.toString());
            if (statusCode >= 400) {
                Object exception = servletService.getAttributeForServletRequest(request, EXCEPTION_ATTRIBUTE);
                tx.setStatus(statusCode);
                if (exception != null) {
                    tx.setThrowable((Throwable)exception);
                }
            }
        }
        catch (Throwable t) {
            Agent.LOG.log(Level.FINER, "Unable to get exception info through request attributes", t);
        }
        this.setAppName(tx, sig, servlet);
        String name = null;
        try {
            name = servlet.getClass().getName();
            if (name.startsWith(ORG_APACHE_JSP)) {
                name = name.substring(ORG_APACHE_JSP.length()).replace('.', '/');
                name = WEB_INF_PATTERN.matcher(name).replaceFirst("WEB-INF");
            } else {
                int index = name.lastIndexOf(46);
                if (index > 0) {
                    name = name.substring(index + 1);
                }
            }
            name = JSP_PATTERN.matcher(name).replaceAll(".jsp");
            this.setTransactionName(tx, name);
            String metricName = "Jsp/" + name;
            this.setMetricNameFormat(new SimpleMetricNameFormat(metricName));
        }
        catch (Exception e) {
            Agent.LOG.finer(MessageFormat.format("An error occurred formatting a jsp name : {0}", e.toString()));
            this.setMetricNameFormat(new ClassMethodMetricNameFormat(sig, servlet));
        }
    }

    private void setTransactionName(Transaction tx, String txName) {
        if (!tx.isTransactionNamingEnabled()) {
            return;
        }
        if (txName == null || txName.length() == 0) {
            return;
        }
        HigherPriorityTransactionNamingPolicy policy = HigherPriorityTransactionNamingPolicy.getInstance();
        if (Agent.LOG.isLoggable(Level.FINER) && policy.canSetTransactionName(tx, TransactionNamePriority.JSP)) {
            String msg = MessageFormat.format("Setting transaction name to \"{0}\" using JSP servlet name", txName);
            Agent.LOG.finer(msg);
        }
        policy.setTransactionName(tx, txName, JSP_CATEGORY, TransactionNamePriority.JSP);
    }

    private void setAppName(Transaction tx, ClassMethodSignature sig, Object servlet) {
        try {
            ApplicationNameUtils.setAppNameForServlet(tx, servlet);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Exception setting application name in {0} handling {1}: {2}", JspServletTracer.class.getSimpleName(), sig, e);
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                Agent.LOG.log(Level.FINEST, msg, e);
            }
            Agent.LOG.finer(msg);
        }
    }
}

