/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers.servlet;

import com.newrelic.agent.Agent;
import com.newrelic.agent.metric.MetricName;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.tracers.servlet.ExternalTimeTracker;
import com.newrelic.agent.tracers.servlet.HttpRequest;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ServerTimeTracker {
    protected static final String MISSING_SERVER_NAME_PREFIX = "unknown";
    protected static final String REQUEST_X_START_HEADER = "X-Request-Start";
    private static final Pattern REQUEST_X_START_HEADER_PATTERN = Pattern.compile("([^\\s\\/,(t=)]+)? ?t=([0-9]+)", 32);
    private final long totalServerTime;
    private final Map<String, Long> serverTimes;

    private ServerTimeTracker(HttpRequest httpRequest, long txStartTimeInMillis, long queueTime) {
        String requestXStartHeader = ExternalTimeTracker.getRequestHeader(httpRequest, REQUEST_X_START_HEADER);
        if (requestXStartHeader == null) {
            this.serverTimes = Collections.emptyMap();
            this.totalServerTime = 0L;
        } else {
            this.serverTimes = new HashMap<String, Long>();
            this.totalServerTime = this.initRequestTime(requestXStartHeader, txStartTimeInMillis, queueTime);
        }
    }

    private long initRequestTime(String requestXStartHeader, long txStartTimeInMillis, long queueTime) {
        long totalServerTime = 0L;
        int index = 0;
        long lastServerStartTimeInMicroseconds = 0L;
        String lastServerName = null;
        Matcher matcher = REQUEST_X_START_HEADER_PATTERN.matcher(requestXStartHeader);
        while (matcher.find()) {
            ++index;
            String serverName = matcher.group(1);
            if (serverName == null || serverName.length() == 0) {
                serverName = MISSING_SERVER_NAME_PREFIX + String.valueOf(index);
            }
            long serverStartTimeInMicroseconds = 0L;
            String serverStartTime = matcher.group(2);
            try {
                serverStartTimeInMicroseconds = Long.parseLong(serverStartTime);
                if (lastServerName != null) {
                    long serverTimeInMicroseconds = Math.max(0L, serverStartTimeInMicroseconds - lastServerStartTimeInMicroseconds);
                    if (Agent.LOG.isLoggable(Level.FINEST)) {
                        String msg = MessageFormat.format("{0} start time (microseconds): {1}, {2} start time (in microseconds): {3}, {4} time (in microseconds): {5}", serverName, String.valueOf(serverStartTimeInMicroseconds), lastServerName, String.valueOf(lastServerStartTimeInMicroseconds), lastServerName, String.valueOf(serverTimeInMicroseconds));
                        Agent.LOG.finest(msg);
                    }
                    if (serverTimeInMicroseconds > 0L) {
                        this.serverTimes.put(lastServerName, serverTimeInMicroseconds);
                        totalServerTime += serverTimeInMicroseconds;
                    }
                }
                lastServerStartTimeInMicroseconds = serverStartTimeInMicroseconds;
                lastServerName = serverName;
            }
            catch (NumberFormatException e) {
                String msg = MessageFormat.format("Error parsing server time {0} in {1}: {2}", serverStartTime, REQUEST_X_START_HEADER, e);
                Agent.LOG.log(Level.FINER, msg);
            }
        }
        if (lastServerName != null) {
            long txStartTime = TimeUnit.MICROSECONDS.convert(txStartTimeInMillis, TimeUnit.MILLISECONDS);
            long serverTimeInMicroseconds = Math.max(0L, txStartTime - lastServerStartTimeInMicroseconds - queueTime);
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                String msg = MessageFormat.format("Transaction start time (microseconds): {0}, {1} start time (in microseconds): {2}, queue time (in microseconds): {3}, {4} time (in microseconds): {5}", String.valueOf(txStartTime), lastServerName, String.valueOf(lastServerStartTimeInMicroseconds), String.valueOf(queueTime), lastServerName, String.valueOf(serverTimeInMicroseconds));
                Agent.LOG.finest(msg);
            }
            if (serverTimeInMicroseconds > 0L) {
                this.serverTimes.put(lastServerName, serverTimeInMicroseconds);
                totalServerTime += serverTimeInMicroseconds;
            }
        }
        return totalServerTime;
    }

    public long getServerTime() {
        return this.totalServerTime;
    }

    public void recordMetrics(TransactionStats statsEngine) {
        if (this.totalServerTime > 0L) {
            this.recordAllServerTimeMetric(statsEngine, this.totalServerTime);
            for (Map.Entry<String, Long> entry : this.serverTimes.entrySet()) {
                this.recordServerTimeMetric(statsEngine, entry.getKey(), entry.getValue());
            }
        }
    }

    private void recordServerTimeMetric(TransactionStats statsEngine, String serverName, long serverTime) {
        String name = "WebFrontend/WebServer/" + serverName;
        statsEngine.getUnscopedStats().getResponseTimeStats(name).recordResponseTime(serverTime, TimeUnit.MICROSECONDS);
        if (Agent.LOG.isLoggable(Level.FINEST)) {
            String msg = MessageFormat.format("Recorded metric: {0}, value: {1}", name, String.valueOf(serverTime));
            Agent.LOG.finest(msg);
        }
    }

    private void recordAllServerTimeMetric(TransactionStats statsEngine, long totalServerTime) {
        MetricName name = MetricName.WEBFRONTEND_WEBSERVER_ALL;
        statsEngine.getUnscopedStats().getResponseTimeStats(name.getName()).recordResponseTime(totalServerTime, TimeUnit.MICROSECONDS);
    }

    public static ServerTimeTracker create(HttpRequest httpRequest, long txStartTimeInMillis, long queueTime) {
        return new ServerTimeTracker(httpRequest, txStartTimeInMillis, queueTime);
    }
}

