/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers.servlet;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.application.ApplicationNameUtils;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.servlet.ServletService;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.IdentityTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.servlet.AbstractHttpResponse;
import com.newrelic.agent.tracers.servlet.AsyncContextNr;
import com.newrelic.agent.tracers.servlet.AsyncDispatcherTracerFactory;
import com.newrelic.agent.tracers.servlet.BasicRequestDispatcherTracer;
import com.newrelic.agent.tracers.servlet.DelegatingServletHttpRequest;
import com.newrelic.agent.tracers.servlet.HttpRequest;
import com.newrelic.agent.tracers.servlet.HttpServletRequest;
import com.newrelic.agent.tracers.servlet.RequestFacadeExtension;
import com.newrelic.agent.tracers.servlet.ServletRequest30TomcatExtension;
import com.newrelic.agent.tracers.servlet.ServletRequestWrapperExtension;
import com.newrelic.agent.tracers.servlet.ServletTracer;
import com.newrelic.agent.transaction.HigherPriorityTransactionNamingPolicy;
import com.newrelic.agent.transaction.TransactionNamePriority;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.logging.Level;

public class ServletTracerFactory
extends AsyncDispatcherTracerFactory {
    public static final String SERVLET_CATEGORY = "Servlet";
    private static final String GET_ASYNC_CONTEXT_METHOD_NAME = "getAsyncContext";
    private static final String SERVLET_REQUEST_CLASS = "javax.servlet.ServletRequest";
    private static volatile Method GET_ASYNC_CONTEXT_METHOD;
    private static volatile boolean IS_INITIALIZED;

    public Tracer getTracer(Transaction tx, ClassMethodSignature sig, Object servlet, Object[] args) {
        Tracer lastTracer = tx.getLastTracer();
        if (lastTracer == null) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)args[0];
            HttpRequest request = DelegatingServletHttpRequest.create(httpServletRequest);
            AsyncContextNr asyncContext = this.getAsyncContext(httpServletRequest, request);
            this.resumeSavedTransaction(asyncContext);
            return this.getDispatcherTracer(tx, sig, servlet, request, args[1]);
        }
        int identityHashCode = System.identityHashCode(servlet);
        if (this.isIdentical(lastTracer, identityHashCode, sig, servlet)) {
            return null;
        }
        this.setAppName(tx, sig, servlet);
        this.setTransactionName(tx, sig, servlet);
        return new ServletTracer(null, tx, sig, servlet, args, identityHashCode);
    }

    private AsyncContextNr getAsyncContext(HttpServletRequest httpServletRequest, HttpRequest request) {
        AsyncContextNr asyncContext = null;
        try {
            asyncContext = request.getAsyncContextNr();
        }
        catch (IllegalStateException e) {
            Agent.LOG.finest(MessageFormat.format("Exception getting async context {0}", e));
            asyncContext = this.getGlassfishAsyncContext(httpServletRequest);
        }
        return asyncContext;
    }

    private AsyncContextNr getGlassfishAsyncContext(HttpServletRequest httpServletRequest) {
        Object servletRequest = null;
        if (httpServletRequest instanceof ServletRequestWrapperExtension) {
            ServletRequestWrapperExtension servletRequestWrapperExtension = (ServletRequestWrapperExtension)((Object)httpServletRequest);
            servletRequest = servletRequestWrapperExtension._nr_getRequest();
        }
        if (servletRequest == null) {
            return null;
        }
        Object requestFacadeExtension = null;
        if (servletRequest instanceof RequestFacadeExtension) {
            requestFacadeExtension = ((RequestFacadeExtension)servletRequest)._nr_getRequest();
        }
        if (requestFacadeExtension == null) {
            return null;
        }
        Object asyncContext = null;
        if (requestFacadeExtension instanceof ServletRequest30TomcatExtension) {
            asyncContext = ((ServletRequest30TomcatExtension)requestFacadeExtension)._nr_getAsyncContext2();
        }
        if (asyncContext == null) {
            return null;
        }
        if (asyncContext instanceof AsyncContextNr) {
            return (AsyncContextNr)asyncContext;
        }
        return null;
    }

    private AsyncContextNr getAsyncContext2(HttpRequest request) {
        if (!IS_INITIALIZED) {
            this.initGetAsyncContext(request);
        }
        if (GET_ASYNC_CONTEXT_METHOD == null) {
            return null;
        }
        AsyncContextNr asyncContext = null;
        try {
            Object o = GET_ASYNC_CONTEXT_METHOD.invoke((Object)request, new Object[0]);
            if (o instanceof AsyncContextNr) {
                // empty if block
            }
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Exception invoking getAsyncContext method on {0}: {1}", request.getClass().getName(), e);
            Agent.LOG.finest(msg);
        }
        return asyncContext;
    }

    private synchronized void initGetAsyncContext(HttpRequest request) {
        if (IS_INITIALIZED) {
            return;
        }
        IS_INITIALIZED = true;
        try {
            ClassLoader classLoader = request.getClass().getClassLoader();
            Class<?> servletRequestClass = classLoader.loadClass(SERVLET_REQUEST_CLASS);
            GET_ASYNC_CONTEXT_METHOD = servletRequestClass.getDeclaredMethod(GET_ASYNC_CONTEXT_METHOD_NAME, new Class[0]);
            GET_ASYNC_CONTEXT_METHOD.setAccessible(true);
        }
        catch (Exception e) {
            GET_ASYNC_CONTEXT_METHOD = null;
            String msg = MessageFormat.format("Exception initializing getAsyncContext: {0}", e);
            Agent.LOG.warning(msg);
        }
    }

    private Tracer getDispatcherTracer(Transaction tx, ClassMethodSignature sig, Object servlet, HttpRequest request, Object response) {
        return new BasicRequestDispatcherTracer(tx, sig, servlet, request, new AbstractHttpResponse(response){

            public String _nr_getResponseStatusMessage() throws Exception {
                return null;
            }

            public int _nr_getResponseStatus() throws Exception {
                return 200;
            }

            public String _nr_getContentType() throws Exception {
                return null;
            }
        });
    }

    private boolean isIdentical(Tracer lastTracer, int identityHashCode, ClassMethodSignature sig, Object servlet) {
        if (lastTracer instanceof IdentityTracer && ((IdentityTracer)lastTracer).getIdentityHashCode() == identityHashCode) {
            if (Agent.isDebugEnabled()) {
                String msg = MessageFormat.format("Skipping {0}.{1} invocation because a parent has us covered", servlet.getClass().getName(), sig.getMethodName());
                Agent.LOG.finer(msg);
            }
            return true;
        }
        return false;
    }

    private void setTransactionName(Transaction tx, ClassMethodSignature sig, Object servlet) {
        try {
            if (!tx.isTransactionNamingEnabled()) {
                return;
            }
            this.doSetTransactionName(tx, servlet);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Exception setting transaction name in {0} handling {1}: {2}", ServletTracerFactory.class.getSimpleName(), sig, e);
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                Agent.LOG.log(Level.FINEST, msg, e);
            }
            Agent.LOG.finer(msg);
        }
    }

    private void doSetTransactionName(Transaction tx, Object servlet) throws Exception {
        HigherPriorityTransactionNamingPolicy policy = HigherPriorityTransactionNamingPolicy.getInstance();
        Object servletConfig = null;
        if (!policy.canSetTransactionName(tx, TransactionNamePriority.SERVLET_INIT_PARAM)) {
            return;
        }
        ServletService servletService = ServiceFactory.getServletService();
        servletConfig = servletService.getServletConfigForServlet(servlet);
        if (servletConfig == null) {
            if (Agent.LOG.isLoggable(Level.FINER)) {
                Agent.LOG.finer("Unable to set transaction name - servlet config is null!");
            }
            return;
        }
        String initParam = servletService.getInitParamForServletConfig(servletConfig, "com.newrelic.agent.TRANSACTION_NAME");
        if (initParam != null && initParam.length() > 0) {
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Setting transaction name to \"{0}\" using servlet init parameter", initParam);
                Agent.LOG.finer(msg);
            }
            policy.setTransactionName(tx, initParam, SERVLET_CATEGORY, TransactionNamePriority.SERVLET_INIT_PARAM);
            return;
        }
        if (policy.canSetTransactionName(tx, TransactionNamePriority.SERVLET_NAME)) {
            String servletName = servletService.getServletName(servletConfig);
            if (servletName == null || servletName.length() == 0) {
                return;
            }
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Setting transaction name to \"{0}\" using servlet name", servletName);
                Agent.LOG.finer(msg);
            }
            policy.setTransactionName(tx, servletName, SERVLET_CATEGORY, TransactionNamePriority.SERVLET_NAME);
        }
    }

    private void setAppName(Transaction tx, ClassMethodSignature sig, Object servlet) {
        try {
            ApplicationNameUtils.setAppNameForServlet(tx, servlet);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Exception setting application name in {0} handling {1}: {2}", ServletTracerFactory.class.getSimpleName(), sig, e);
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                Agent.LOG.log(Level.FINEST, msg, e);
            }
            Agent.LOG.finer(msg);
        }
    }
}

