/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.transport;

import com.newrelic.agent.Agent;
import com.newrelic.agent.AgentMessage;
import com.newrelic.agent.MetricData;
import com.newrelic.agent.MetricDataException;
import com.newrelic.agent.config.IAgentConfig;
import com.newrelic.agent.errors.TracedError;
import com.newrelic.agent.profile.Profile;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.sql.SqlTrace;
import com.newrelic.agent.trace.TransactionTrace;
import com.newrelic.agent.transport.DataSender;
import com.newrelic.agent.transport.DataSenderWriter;
import com.newrelic.agent.transport.HttpError;
import com.newrelic.agent.util.RubyConversion;
import com.newrelic.org.apache.axis.encoding.Base64;
import com.newrelic.org.json.simple.JSONArray;
import com.newrelic.org.json.simple.parser.JSONParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.rmi.UnexpectedException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSenderImpl
implements DataSender {
    private static final int PROTOCOL_VERSION = 12;
    private static final int DEFAULT_REQUEST_TIMEOUT_IN_SECONDS = 120;
    private static final String BEFORE_LICENSE_KEY_URI_PATTERN = "/agent_listener/invoke_raw_method?method={0}";
    private static final String AFTER_LICENSE_KEY_URI_PATTERN = "&marshal_format=json&protocol_version=12";
    private static final String LICENSE_KEY_URI_PATTERN = "&license_key={0}";
    private static final String RUN_ID_PATTERN = "&run_id={1}";
    private static final String CONNECT_METHOD = "connect";
    private static final String METRIC_DATA_METHOD = "metric_data";
    private static final String GET_AGENT_COMMANDS_METHOD = "get_agent_commands";
    private static final String AGENT_COMMAND_RESULTS_METHOD = "agent_command_results";
    private static final String GET_REDIRECT_HOST_METHOD = "get_redirect_host";
    private static final String ERROR_DATA_METHOD = "error_data";
    private static final String PROFILE_DATA_METHOD = "profile_data";
    private static final String QUEUE_PING_COMMAND_METHOD = "queue_ping_command";
    private static final String MESSAGE_DATA_METHOD = "message_data";
    private static final String SHUTDOWN_METHOD = "shutdown";
    private static final String SQL_TRACE_DATA_METHOD = "sql_trace_data";
    private static final String TRANSACTION_SAMPLE_DATA_METHOD = "transaction_sample_data";
    private static final String USER_AGENT_HEADER_NAME = "User-Agent";
    private static final String USER_AGENT_HEADER_VALUE = DataSenderImpl.initUserHeaderValue();
    private static final String GZIP = "gzip";
    private static final String DEFLATE_ENCODING = "deflate";
    private static final String IDENTITY_ENCODING = "identity";
    private static final String RESPONSE_MAP_EXCEPTION_KEY = "exception";
    private static final String EXCEPTION_MAP_MESSAGE_KEY = "message";
    private static final String EXCEPTION_MAP_ERROR_TYPE_KEY = "error_type";
    private static final String EXCEPTION_MAP_RETURN_VALUE_KEY = "return_value";
    private static final String AGENT_RUN_ID_KEY = "agent_run_id";
    private static final String SSL_KEY = "ssl";
    private static final int NO_AGENT_RUN_ID = 0;
    private static final String NULL_RESPONSE = "null";
    private static final String TIMEOUT_PROPERTY = "timeout";
    private static final String BASIC_AUTH = "Basic";
    private static final int COMPRESSION_LEVEL = -1;
    private volatile String host;
    private final int port;
    private volatile String protocol;
    private final Proxy proxy;
    private final String proxyUser;
    private final String proxyPass;
    private final int defaultTimeoutInMillis;
    private volatile boolean auditMode;
    private volatile int agentRunId = 0;
    private final String agentRunIdUriPattern;
    private final String noAgentRunIdUriPattern;

    private static String initUserHeaderValue() {
        String arch = "unknown";
        String javaVersion = "unknown";
        try {
            arch = System.getProperty("os.arch");
            javaVersion = System.getProperty("java.version");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return MessageFormat.format("NewRelic-JavaAgent/{0} (java {1} {2})", Agent.getVersion(), javaVersion, arch);
    }

    public DataSenderImpl(IAgentConfig config) {
        this.auditMode = config.isAuditMode();
        Agent.LOG.info(MessageFormat.format("Setting audit_mode to {0}", this.auditMode));
        this.host = config.getHost();
        this.port = config.getPort();
        this.protocol = config.isSSL() ? "https" : "http";
        String msg = MessageFormat.format("Setting protocol to \"{0}\"", this.protocol);
        Agent.LOG.info(msg);
        String proxyHost = config.getProxyHost();
        Integer proxyPort = config.getProxyPort();
        if (proxyHost != null && proxyPort != null) {
            this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, (int)proxyPort));
            this.proxyUser = config.getProxyUser();
            this.proxyPass = config.getProxyPassword();
            msg = MessageFormat.format("Using proxy host {0}:{1}", proxyHost, Integer.toString(proxyPort));
            Agent.LOG.fine(msg);
        } else {
            this.proxy = null;
            this.proxyUser = null;
            this.proxyPass = null;
        }
        this.defaultTimeoutInMillis = config.getProperty(TIMEOUT_PROPERTY, 120) * 1000;
        String licenseKeyUri = MessageFormat.format(LICENSE_KEY_URI_PATTERN, config.getLicenseKey());
        this.noAgentRunIdUriPattern = BEFORE_LICENSE_KEY_URI_PATTERN + licenseKeyUri + AFTER_LICENSE_KEY_URI_PATTERN;
        this.agentRunIdUriPattern = this.noAgentRunIdUriPattern + RUN_ID_PATTERN;
    }

    private void checkAuditMode() {
        boolean auditMode2 = ServiceFactory.getConfigService().getLocalAgentConfig().isAuditMode();
        if (this.auditMode != auditMode2) {
            this.auditMode = auditMode2;
            Agent.LOG.info(MessageFormat.format("Setting audit_mode to {0}", this.auditMode));
        }
    }

    private void setAgentRunId(int runId) {
        this.agentRunId = runId;
        if (runId != 0) {
            String msg = MessageFormat.format("Agent run id: {0}", Long.toString(runId));
            Agent.LOG.info(msg);
        }
    }

    @Override
    public Map<String, Object> connect(Map<String, Object> startupOptions) throws Exception {
        String redirectHost = this.getRedirectHost();
        if (redirectHost != null) {
            this.host = redirectHost;
            String msg = MessageFormat.format("Collector redirection to {0}:{1}", this.host, Integer.toString(this.port));
            Agent.LOG.info(msg);
        }
        return this.doConnect(startupOptions);
    }

    private String getRedirectHost() throws Exception {
        Object response = this.invokeNoRunId(GET_REDIRECT_HOST_METHOD, DEFLATE_ENCODING, Collections.<Object>emptyList());
        return response == null ? null : response.toString();
    }

    private Map<String, Object> doConnect(Map<String, Object> startupOptions) throws Exception {
        ArrayList<Object> params = new ArrayList<Object>(1);
        params.add(startupOptions);
        Object response = this.invokeNoRunId(CONNECT_METHOD, DEFLATE_ENCODING, params);
        if (!(response instanceof Map)) {
            String msg = MessageFormat.format("Expected a map of connection data, got {0}", response);
            throw new UnexpectedException(msg);
        }
        Map data = (Map)response;
        if (!data.containsKey(AGENT_RUN_ID_KEY)) {
            String msg = MessageFormat.format("Missing {0} connection parameter", AGENT_RUN_ID_KEY);
            throw new UnexpectedException(msg);
        }
        int runId = ((Long)data.get(AGENT_RUN_ID_KEY)).intValue();
        this.setAgentRunId(runId);
        Object ssl = data.get(SSL_KEY);
        if (Boolean.TRUE.equals(ssl)) {
            Agent.LOG.info("Setting protocol to \"https\"");
            this.protocol = "https";
        }
        return data;
    }

    @Override
    public List<List<?>> getAgentCommands() throws Exception {
        this.checkAuditMode();
        int runId = this.agentRunId;
        if (runId == 0) {
            return Collections.emptyList();
        }
        ArrayList<Object> params = new ArrayList<Object>(1);
        params.add(runId);
        Object response = this.invokeRunId(GET_AGENT_COMMANDS_METHOD, DEFLATE_ENCODING, runId, params);
        if (response == null || NULL_RESPONSE.equals(response)) {
            return Collections.emptyList();
        }
        try {
            return (List)response;
        }
        catch (ClassCastException e) {
            String msg = MessageFormat.format("Invalid response getting agent commands: {0}", e);
            Agent.LOG.warning(msg);
            throw e;
        }
    }

    @Override
    public void queuePingCommand() throws Exception {
        int runId = this.agentRunId;
        if (runId == 0) {
            return;
        }
        ArrayList<Object> params = new ArrayList<Object>(1);
        params.add(runId);
        this.invokeRunId(QUEUE_PING_COMMAND_METHOD, DEFLATE_ENCODING, runId, params);
    }

    @Override
    public void sendCommandResults(Map<Long, Object> commandResults) throws Exception {
        int runId = this.agentRunId;
        if (runId == 0 || commandResults.isEmpty()) {
            return;
        }
        ArrayList<Object> params = new ArrayList<Object>(2);
        params.add(runId);
        params.add(commandResults);
        this.invokeRunId(AGENT_COMMAND_RESULTS_METHOD, DEFLATE_ENCODING, runId, params);
    }

    @Override
    public void sendErrorData(List<TracedError> errors) throws Exception {
        int runId = this.agentRunId;
        if (runId == 0 || errors.isEmpty()) {
            return;
        }
        ArrayList<Object> params = new ArrayList<Object>(2);
        params.add(runId);
        params.add(errors);
        this.invokeRunId(ERROR_DATA_METHOD, IDENTITY_ENCODING, runId, params);
    }

    @Override
    public void sendMessageData(List<AgentMessage> errors) throws Exception {
        int runId = this.agentRunId;
        if (runId == 0 || errors.isEmpty()) {
            return;
        }
        ArrayList<Object> params = new ArrayList<Object>(2);
        params.add(runId);
        params.add(errors);
        this.invokeRunId(MESSAGE_DATA_METHOD, DEFLATE_ENCODING, runId, params);
    }

    @Override
    public List<List<?>> sendMetricData(long beginTimeMillis, long endTimeMillis, List<MetricData> metricData) throws Exception {
        int runId = this.agentRunId;
        if (runId == 0 || metricData.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> params = new ArrayList<Object>(4);
        params.add(runId);
        params.add(beginTimeMillis / 1000L);
        params.add(endTimeMillis / 1000L);
        params.add(metricData);
        Object response = this.invokeRunId(METRIC_DATA_METHOD, DEFLATE_ENCODING, runId, params);
        if (response == null || NULL_RESPONSE.equals(response)) {
            throw new MetricDataException("Invalid null response sending metric data");
        }
        try {
            return (List)response;
        }
        catch (ClassCastException e) {
            String msg = MessageFormat.format("Invalid response sending metric data: {0}", e);
            Agent.LOG.warning(msg);
            throw e;
        }
    }

    @Override
    public List<Long> sendProfileData(List<Profile> profiles) throws Exception {
        int runId = this.agentRunId;
        if (runId == 0 || profiles.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> params = new ArrayList<Object>(2);
        params.add(runId);
        params.add(profiles);
        Object response = this.invokeRunId(PROFILE_DATA_METHOD, IDENTITY_ENCODING, runId, params);
        if (response == null || NULL_RESPONSE.equals(response)) {
            return Collections.emptyList();
        }
        try {
            return (List)response;
        }
        catch (ClassCastException e) {
            String msg = MessageFormat.format("Invalid response sending profiles: {0}", e);
            Agent.LOG.warning(msg);
            throw e;
        }
    }

    @Override
    public void sendSqlTraceData(List<SqlTrace> sqlTraces) throws Exception {
        int runId = this.agentRunId;
        if (runId == 0 || sqlTraces.isEmpty()) {
            return;
        }
        ArrayList<Object> params = new ArrayList<Object>(1);
        params.add(sqlTraces);
        Object response = this.invokeRunId(SQL_TRACE_DATA_METHOD, IDENTITY_ENCODING, runId, params);
        if (response == null || NULL_RESPONSE.equals(response)) {
            return;
        }
        String msg = MessageFormat.format("Invalid response sending sql traces {0}", response);
        Agent.LOG.warning(msg);
    }

    @Override
    public void sendTransactionTraceData(List<TransactionTrace> traces) throws Exception {
        int runId = this.agentRunId;
        if (runId == 0 || traces.isEmpty()) {
            return;
        }
        ArrayList<Object> params = new ArrayList<Object>(2);
        params.add(runId);
        params.add(traces);
        Object response = this.invokeRunId(TRANSACTION_SAMPLE_DATA_METHOD, IDENTITY_ENCODING, runId, params);
        if (response == null || NULL_RESPONSE.equals(response)) {
            return;
        }
        String msg = MessageFormat.format("Invalid response sending transaction traces {0}", response);
        Agent.LOG.warning(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(long timeMillis) throws Exception {
        int runId = this.agentRunId;
        if (runId == 0) {
            return;
        }
        ArrayList<Object> params = new ArrayList<Object>(2);
        params.add(runId);
        params.add(timeMillis);
        int requestTimeoutInMillis = 10000;
        try {
            this.invokeRunId(SHUTDOWN_METHOD, DEFLATE_ENCODING, runId, requestTimeoutInMillis, params);
        }
        finally {
            this.setAgentRunId(0);
        }
    }

    private Object invokeRunId(String method, String encoding, int runId, List<Object> params) throws Exception {
        return this.invokeRunId(method, encoding, runId, this.defaultTimeoutInMillis, params);
    }

    private Object invokeRunId(String method, String encoding, int runId, int timeoutInMillis, List<Object> params) throws Exception {
        String uri = MessageFormat.format(this.agentRunIdUriPattern, method, String.valueOf(runId));
        return this.invoke(method, encoding, uri, params, timeoutInMillis);
    }

    private Object invokeNoRunId(String method, String encoding, List<Object> params) throws Exception {
        String uri = MessageFormat.format(this.noAgentRunIdUriPattern, method);
        return this.invoke(method, encoding, uri, params, this.defaultTimeoutInMillis);
    }

    private Object invoke(String method, String encoding, String uri, List<Object> params, int timeoutInMillis) throws Exception {
        ReadResult readResult = this.send(method, encoding, uri, params, timeoutInMillis);
        Map<?, ?> responseMap = null;
        Exception ex = null;
        try {
            responseMap = this.getResponseMap(readResult.getResponseBody());
            ex = this.parseException(responseMap);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Error parsing response JSON({0}): {1}", method, e);
            Agent.LOG.warning(msg);
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                msg = MessageFormat.format("Invalid response JSON({0}): {1}", method, readResult.getResponseBody());
                Agent.LOG.finer(msg);
            }
            throw e;
        }
        if (ex != null) {
            throw ex;
        }
        int responseCode = readResult.getResponseCode();
        if (responseCode != 200) {
            throw new HttpError(readResult.getResponseBody(), responseCode);
        }
        return responseMap.get(EXCEPTION_MAP_RETURN_VALUE_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ReadResult connectAndSend(String method, String encoding, String uri, List<Object> params, int timeoutInMillis) throws Exception {
        HttpURLConnection conn = null;
        try {
            conn = this.createConnection(encoding, uri, timeoutInMillis);
            IOException err = null;
            try {
                this.writeData(conn, encoding, params);
            }
            catch (IOException e) {
                err = e;
                Agent.LOG.info("connection error: " + e);
            }
            if (conn.getResponseCode() == 407) {
                String authField = conn.getHeaderField("Proxy-Authenticate");
                if (authField == null || !authField.startsWith(BASIC_AUTH)) throw new Exception("unsupported proxy authentication mechanism: " + authField);
                Agent.LOG.info("Received Proxy-Authenticate challenge: " + authField);
                conn.disconnect();
                conn = this.createConnection(encoding, uri, timeoutInMillis);
                this.addBasicProxyAuthHeaders(conn);
                this.writeData(conn, encoding, params);
            } else if (err != null) {
                throw err;
            }
            if (conn.getResponseCode() != 200) {
                Agent.LOG.finer("connection http status code: " + conn.getResponseCode());
            }
            if (this.auditMode) {
                String msg = MessageFormat.format("Sent JSON({0}) to: {1}\n{2}", method, conn.getURL(), DataSenderWriter.toJSONString(params));
                Agent.LOG.info(msg);
            }
            String responseBody = this.readResponseBody(conn);
            if (this.auditMode) {
                String msg = MessageFormat.format("Received JSON({0}): {1}", method, responseBody);
                Agent.LOG.info(msg);
            }
            ReadResult readResult = ReadResult.create(conn.getResponseCode(), responseBody);
            return readResult;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private ReadResult send(String method, String encoding, String uri, List<Object> params, int timeoutInMillis) throws Exception {
        try {
            return this.connectAndSend(method, encoding, uri, params, timeoutInMillis);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Error sending JSON({0}): {1}", method, e);
            Agent.LOG.warning(msg);
            if (Agent.LOG.isLoggable(Level.FINE)) {
                msg = MessageFormat.format("Error sending JSON({0}): {1}", method, DataSenderWriter.toJSONString(params));
                Agent.LOG.fine(msg);
            }
            throw e;
        }
    }

    private String encodeBasicAuth(String user, String pass) {
        return "Basic " + Base64.encode((user + ":" + pass).getBytes());
    }

    private HttpURLConnection createConnection(String encoding, String uri, int requestTimeoutInMillis) throws Exception {
        URL url = new URL(this.protocol, this.host, this.port, uri);
        HttpURLConnection conn = (HttpURLConnection)(this.proxy == null ? url.openConnection() : url.openConnection(this.proxy));
        conn.setRequestProperty("Connection", "Keep-Alive");
        conn.setRequestProperty(USER_AGENT_HEADER_NAME, USER_AGENT_HEADER_VALUE);
        conn.setConnectTimeout(requestTimeoutInMillis);
        conn.setReadTimeout(requestTimeoutInMillis);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setRequestProperty("CONTENT-TYPE", "application/octet-stream");
        conn.setRequestProperty("ACCEPT-ENCODING", GZIP);
        conn.setRequestProperty("CONTENT-ENCODING", encoding);
        return conn;
    }

    private void addBasicProxyAuthHeaders(HttpURLConnection conn) {
        if (this.proxyUser != null && this.proxyPass != null) {
            conn.setRequestProperty("Proxy-Connection", "Keep-Alive");
            conn.setRequestProperty("Proxy-Authorization", this.encodeBasicAuth(this.proxyUser, this.proxyPass));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeData(HttpURLConnection conn, String encoding, List<Object> params) throws IOException {
        Writer out = null;
        try {
            OutputStream os = this.getOutputStream(conn, encoding);
            out = new OutputStreamWriter(os, "UTF-8");
            JSONArray.writeJSONString(params, out);
            out.flush();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private OutputStream getOutputStream(HttpURLConnection conn, String encoding) throws IOException {
        if (DEFLATE_ENCODING.equals(encoding)) {
            return new DeflaterOutputStream(conn.getOutputStream(), new Deflater(-1));
        }
        return conn.getOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readResponseBody(HttpURLConnection conn) throws Exception {
        InputStream is = conn.getInputStream();
        BufferedReader in = this.getBufferedReader(conn, is);
        try {
            String string = in.readLine();
            return string;
        }
        finally {
            in.close();
            is.close();
        }
    }

    private Map<?, ?> getResponseMap(String responseBody) throws Exception {
        JSONParser parser = new JSONParser();
        Object response = parser.parse(responseBody);
        return (Map)Map.class.cast(response);
    }

    private BufferedReader getBufferedReader(HttpURLConnection conn, InputStream is) throws IOException {
        String encoding = conn.getHeaderField("content-encoding");
        if (GZIP.equals(encoding)) {
            is = new GZIPInputStream(is);
        }
        return new BufferedReader(new InputStreamReader(is, "UTF-8"));
    }

    private Exception parseException(Map<?, ?> responseMap) throws Exception {
        String message;
        Object exception = responseMap.get(RESPONSE_MAP_EXCEPTION_KEY);
        if (exception == null) {
            return null;
        }
        Map exceptionMap = (Map)Map.class.cast(exception);
        try {
            message = (String)exceptionMap.get(EXCEPTION_MAP_MESSAGE_KEY);
        }
        catch (Exception e) {
            message = exceptionMap.toString();
        }
        String type = (String)exceptionMap.get(EXCEPTION_MAP_ERROR_TYPE_KEY);
        Class<Exception> clazz = RubyConversion.rubyClassToJavaClass(type);
        Constructor<Exception> constructor = clazz.getConstructor(String.class);
        return constructor.newInstance(message);
    }

    private static final class ReadResult {
        private final int responseCode;
        private final String responseBody;

        private ReadResult(int responseCode, String responseBody) {
            this.responseCode = responseCode;
            this.responseBody = responseBody;
        }

        private int getResponseCode() {
            return this.responseCode;
        }

        private String getResponseBody() {
            return this.responseBody;
        }

        private static ReadResult create(int responseCode, String responseBody) {
            return new ReadResult(responseCode, responseBody);
        }
    }
}

