/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.transport;

import com.newrelic.org.apache.axis.encoding.Base64;
import com.newrelic.org.json.simple.JSONValue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class DataSenderWriter
extends OutputStreamWriter {
    private static final int COMPRESSION_LEVEL = -1;

    protected DataSenderWriter(OutputStream out) {
        super(out);
    }

    public static final String nullValue() {
        return "null";
    }

    public static final boolean isCompressingWriter(Writer writer) {
        return !(writer instanceof DataSenderWriter);
    }

    public static final String getJsonifiedCompressedEncodedString(Object data, Writer writer) {
        return DataSenderWriter.getJsonifiedCompressedEncodedString(data, writer, -1);
    }

    public static final String getJsonifiedCompressedEncodedString(Object data, Writer writer, int compressionLevel) {
        if (writer instanceof DataSenderWriter) {
            return DataSenderWriter.toJSONString(data);
        }
        return DataSenderWriter.getJsonifiedCompressedEncodedString(data, compressionLevel);
    }

    public static final String toJSONString(Object obj) {
        ByteArrayOutputStream oStream = new ByteArrayOutputStream();
        DataSenderWriter writer = new DataSenderWriter(oStream);
        try {
            JSONValue.writeJSONString(obj, writer);
            ((Writer)writer).close();
            return oStream.toString();
        }
        catch (IOException e) {
            return JSONValue.toJSONString(obj);
        }
    }

    private static final String getJsonifiedCompressedEncodedString(Object data, int compressionLevel) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        DeflaterOutputStream zipStream = new DeflaterOutputStream((OutputStream)outStream, new Deflater(compressionLevel));
        OutputStreamWriter out = new OutputStreamWriter(zipStream);
        try {
            JSONValue.writeJSONString(data, out);
            ((Writer)out).flush();
            ((Writer)out).close();
            outStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Base64.encode(outStream.toByteArray());
    }
}

