/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.util;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldCache {
    static final int DEFAULT_MAX_SIZE = 100;
    private final Map<Class<?>, Field> fields = new ConcurrentHashMap();
    private final String fieldName;
    private final int maxSize;

    public FieldCache(String fieldName) {
        this(fieldName, 100);
    }

    public FieldCache(String fieldName, int maxSize) {
        this.fieldName = fieldName;
        this.maxSize = maxSize;
    }

    public Field getField(Class<?> clazz) throws NoSuchFieldException {
        Field field = this.fields.get(clazz);
        if (field != null) {
            return field;
        }
        Class<?> classToSearch = clazz;
        while (field == null) {
            try {
                field = classToSearch.getDeclaredField(this.fieldName);
                field.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                classToSearch = clazz.getSuperclass();
                if (classToSearch != null) continue;
                throw e;
            }
        }
        if (this.fields.size() == this.maxSize) {
            this.fields.clear();
        }
        this.fields.put(clazz, field);
        return field;
    }

    public void clear() {
        this.fields.clear();
    }

    int getSize() {
        return this.fields.size();
    }
}

