/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.util;

import com.newrelic.org.objectweb.asm.Type;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Streams {
    public static final int DEFAULT_BUFFER_SIZE = 8192;

    private Streams() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getClassBytes(Class clazz) throws IOException {
        String name = Type.getInternalName(clazz) + ".class";
        InputStream iStream = clazz.getClassLoader().getResourceAsStream(name);
        try {
            ByteArrayOutputStream oStream = new ByteArrayOutputStream();
            Streams.copy(iStream, oStream);
            byte[] byArray = oStream.toByteArray();
            return byArray;
        }
        finally {
            iStream.close();
        }
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        return Streams.copy(input, output, 8192, false);
    }

    public static int copy(InputStream input, OutputStream output, boolean closeStreams) throws IOException {
        return Streams.copy(input, output, 8192, closeStreams);
    }

    public static int copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        return Streams.copy(input, output, bufferSize, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(InputStream input, OutputStream output, int bufferSize, boolean closeStreams) throws IOException {
        try {
            byte[] buffer = new byte[bufferSize];
            int count = 0;
            int n = 0;
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
                count += n;
            }
            int n2 = count;
            return n2;
        }
        finally {
            if (closeStreams) {
                input.close();
                output.close();
            }
        }
    }
}

