/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.org.yaml.snakeyaml.serializer;

import com.newrelic.org.yaml.snakeyaml.DumperOptions;
import com.newrelic.org.yaml.snakeyaml.emitter.Emitter;
import com.newrelic.org.yaml.snakeyaml.events.AliasEvent;
import com.newrelic.org.yaml.snakeyaml.events.DocumentEndEvent;
import com.newrelic.org.yaml.snakeyaml.events.DocumentStartEvent;
import com.newrelic.org.yaml.snakeyaml.events.MappingEndEvent;
import com.newrelic.org.yaml.snakeyaml.events.MappingStartEvent;
import com.newrelic.org.yaml.snakeyaml.events.ScalarEvent;
import com.newrelic.org.yaml.snakeyaml.events.SequenceEndEvent;
import com.newrelic.org.yaml.snakeyaml.events.SequenceStartEvent;
import com.newrelic.org.yaml.snakeyaml.events.StreamEndEvent;
import com.newrelic.org.yaml.snakeyaml.events.StreamStartEvent;
import com.newrelic.org.yaml.snakeyaml.nodes.CollectionNode;
import com.newrelic.org.yaml.snakeyaml.nodes.Node;
import com.newrelic.org.yaml.snakeyaml.nodes.NodeId;
import com.newrelic.org.yaml.snakeyaml.nodes.ScalarNode;
import com.newrelic.org.yaml.snakeyaml.resolver.Resolver;
import com.newrelic.org.yaml.snakeyaml.serializer.SerializerException;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Serializer {
    private final Emitter emitter;
    private final Resolver resolver;
    private boolean explicitStart;
    private boolean explicitEnd;
    private Integer[] useVersion;
    private Map<String, String> useTags;
    private Set<Node> serializedNodes;
    private Map<Node, String> anchors;
    private int lastAnchorId;
    private Boolean closed;
    private String explicitRoot;

    public Serializer(Emitter emitter, Resolver resolver, DumperOptions opts) {
        this.emitter = emitter;
        this.resolver = resolver;
        this.explicitStart = opts.isExplicitStart();
        this.explicitEnd = opts.isExplicitEnd();
        if (opts.getVersion() != null) {
            this.useVersion = opts.getVersion().getArray();
        }
        this.useTags = opts.getTags();
        this.serializedNodes = new HashSet<Node>();
        this.anchors = new HashMap<Node, String>();
        this.lastAnchorId = 0;
        this.closed = null;
        this.explicitRoot = opts.getExplicitRoot();
    }

    public void open() throws IOException {
        if (this.closed != null) {
            if (Boolean.TRUE.equals(this.closed)) {
                throw new SerializerException("serializer is closed");
            }
            throw new SerializerException("serializer is already opened");
        }
        this.emitter.emit(new StreamStartEvent(null, null));
        this.closed = Boolean.FALSE;
    }

    public void close() throws IOException {
        if (this.closed == null) {
            throw new SerializerException("serializer is not opened");
        }
        if (!Boolean.TRUE.equals(this.closed)) {
            this.emitter.emit(new StreamEndEvent(null, null));
            this.closed = Boolean.TRUE;
        }
    }

    public void serialize(Node node) throws IOException {
        if (this.closed == null) {
            throw new SerializerException("serializer is not opened");
        }
        if (this.closed.booleanValue()) {
            throw new SerializerException("serializer is closed");
        }
        this.emitter.emit(new DocumentStartEvent(null, null, this.explicitStart, this.useVersion, this.useTags));
        this.anchorNode(node);
        if (this.explicitRoot != null) {
            node.setTag(this.explicitRoot);
        }
        this.serializeNode(node, null, null);
        this.emitter.emit(new DocumentEndEvent(null, null, this.explicitEnd));
        this.serializedNodes.clear();
        this.anchors.clear();
        this.lastAnchorId = 0;
    }

    private void anchorNode(Node node) {
        if (this.anchors.containsKey(node)) {
            String anchor = this.anchors.get(node);
            if (null == anchor) {
                anchor = this.generateAnchor();
                this.anchors.put(node, anchor);
            }
        } else {
            this.anchors.put(node, null);
            switch (node.getNodeId()) {
                case sequence: {
                    List list = (List)node.getValue();
                    for (Node item : list) {
                        this.anchorNode(item);
                    }
                    break;
                }
                case mapping: {
                    List map = (List)node.getValue();
                    for (Object[] object : map) {
                        Node key = (Node)object[0];
                        Node value = (Node)object[1];
                        this.anchorNode(key);
                        this.anchorNode(value);
                    }
                    break;
                }
            }
        }
    }

    private String generateAnchor() {
        ++this.lastAnchorId;
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMinimumIntegerDigits(3);
        String anchorId = format.format(this.lastAnchorId);
        return "id" + anchorId;
    }

    private void serializeNode(Node node, Node parent, Object index) throws IOException {
        String tAlias = this.anchors.get(node);
        if (this.serializedNodes.contains(node)) {
            this.emitter.emit(new AliasEvent(tAlias, null, null));
        } else {
            this.serializedNodes.add(node);
            switch (node.getNodeId()) {
                case scalar: {
                    String detectedTag = this.resolver.resolve(NodeId.scalar, (String)node.getValue(), true);
                    String defaultTag = this.resolver.resolve(NodeId.scalar, (String)node.getValue(), false);
                    boolean[] implicit = new boolean[]{false, false};
                    implicit[0] = node.getTag().equals(detectedTag);
                    implicit[1] = node.getTag().equals(defaultTag);
                    ScalarEvent event = new ScalarEvent(tAlias, node.getTag(), implicit, (String)node.getValue(), null, null, ((ScalarNode)node).getStyle());
                    this.emitter.emit(event);
                    break;
                }
                case sequence: {
                    boolean implicitS = node.getTag().equals(this.resolver.resolve(NodeId.sequence, null, true));
                    this.emitter.emit(new SequenceStartEvent(tAlias, node.getTag(), implicitS, null, null, ((CollectionNode)node).getFlowStyle()));
                    int indexCounter = 0;
                    List list = (List)node.getValue();
                    for (Node item : list) {
                        this.serializeNode(item, node, new Integer(indexCounter));
                        ++indexCounter;
                    }
                    this.emitter.emit(new SequenceEndEvent(null, null));
                    break;
                }
                default: {
                    String implicitTag = this.resolver.resolve(NodeId.mapping, null, true);
                    boolean implicitM = node.getTag().equals(implicitTag);
                    this.emitter.emit(new MappingStartEvent(tAlias, node.getTag(), implicitM, null, null, ((CollectionNode)node).getFlowStyle()));
                    List map = (List)node.getValue();
                    for (Object[] row : map) {
                        Node key = (Node)row[0];
                        Node value = (Node)row[1];
                        this.serializeNode(key, node, null);
                        this.serializeNode(value, node, key);
                    }
                    this.emitter.emit(new MappingEndEvent(null, null));
                }
            }
        }
    }
}

