package com.newrelic.api.agent;

/**
 * The New Relic Java Agent's API.
 * 
 * @author sdaubin
 * 
 */
public interface Agent {

    /**
     * Returns the current traced method. This can only be invoked within methods that are traced.
     * 
     * @return The current method being traced.
     * @see Trace
     */
    TracedMethod getTracedMethod();

    /**
     * Returns the current transaction, creating one if it doesn't currently exist.
     * 
     * @return The current transaction.
     */
    Transaction getTransaction();

    /**
     * Returns a logger that logs to the New Relic Java agent log file.
     * 
     * @return A log where messages can be written to the New Relic Java agent log file.
     */
    Logger getLogger();

    /**
     * Returns the agent's configuration.
     * 
     * @return The configuration of this Java agent.
     */
    Config getConfig();

    /**
     * Returns a metric aggregator that can be used to record metrics that can be viewed through custom dashboards.
     * 
     * @return Aggregator used to record metrics for custom dashboards.
     */
    MetricAggregator getMetricAggregator();

    /**
     * Provides access to the Insights custom events API.
     * 
     * @return Object used to add custom events.
     */
    Insights getInsights();
}
