/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client;

import com.nexmo.client.HttpConfig;
import com.nexmo.client.HttpWrapper;
import com.nexmo.client.NexmoClientCreationException;
import com.nexmo.client.NexmoUnableToReadPrivateKeyException;
import com.nexmo.client.account.AccountClient;
import com.nexmo.client.application.ApplicationClient;
import com.nexmo.client.auth.AuthCollection;
import com.nexmo.client.auth.JWTAuthMethod;
import com.nexmo.client.auth.NexmoUnacceptableAuthException;
import com.nexmo.client.auth.SignatureAuthMethod;
import com.nexmo.client.auth.TokenAuthMethod;
import com.nexmo.client.conversion.ConversionClient;
import com.nexmo.client.insight.InsightClient;
import com.nexmo.client.numbers.NumbersClient;
import com.nexmo.client.redact.RedactClient;
import com.nexmo.client.sms.SmsClient;
import com.nexmo.client.sns.SnsClient;
import com.nexmo.client.verify.VerifyClient;
import com.nexmo.client.voice.VoiceClient;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.http.client.HttpClient;

public class NexmoClient {
    private AccountClient account;
    private ApplicationClient application;
    private InsightClient insight;
    private NumbersClient numbers;
    private SmsClient sms;
    private VoiceClient voice;
    private VerifyClient verify;
    private SnsClient sns;
    private ConversionClient conversion;
    private RedactClient redact;
    private HttpWrapper httpWrapper;

    private NexmoClient(Builder builder) {
        this.httpWrapper = new HttpWrapper(builder.httpConfig, builder.authCollection);
        this.httpWrapper.setHttpClient(builder.httpClient);
        this.account = new AccountClient(this.httpWrapper);
        this.application = new ApplicationClient(this.httpWrapper);
        this.insight = new InsightClient(this.httpWrapper);
        this.numbers = new NumbersClient(this.httpWrapper);
        this.verify = new VerifyClient(this.httpWrapper);
        this.voice = new VoiceClient(this.httpWrapper);
        this.sms = new SmsClient(this.httpWrapper);
        this.sns = new SnsClient(this.httpWrapper);
        this.conversion = new ConversionClient(this.httpWrapper);
        this.redact = new RedactClient(this.httpWrapper);
    }

    public AccountClient getAccountClient() {
        return this.account;
    }

    public ApplicationClient getApplicationClient() {
        return this.application;
    }

    public InsightClient getInsightClient() {
        return this.insight;
    }

    public NumbersClient getNumbersClient() {
        return this.numbers;
    }

    public SmsClient getSmsClient() {
        return this.sms;
    }

    public SnsClient getSnsClient() {
        return this.sns;
    }

    public VerifyClient getVerifyClient() {
        return this.verify;
    }

    public VoiceClient getVoiceClient() {
        return this.voice;
    }

    public ConversionClient getConversionClient() {
        return this.conversion;
    }

    public RedactClient getRedactClient() {
        return this.redact;
    }

    public String generateJwt() throws NexmoUnacceptableAuthException {
        JWTAuthMethod authMethod = this.httpWrapper.getAuthCollection().getAuth(JWTAuthMethod.class);
        return authMethod.generateToken();
    }

    HttpWrapper getHttpWrapper() {
        return this.httpWrapper;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private AuthCollection authCollection;
        private HttpConfig httpConfig = HttpConfig.defaultConfig();
        private HttpClient httpClient;
        private String applicationId;
        private String apiKey;
        private String apiSecret;
        private String signatureSecret;
        private byte[] privateKeyContents;

        public Builder httpConfig(HttpConfig httpConfig) {
            this.httpConfig = httpConfig;
            return this;
        }

        public Builder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder apiSecret(String apiSecret) {
            this.apiSecret = apiSecret;
            return this;
        }

        public Builder signatureSecret(String signatureSecret) {
            this.signatureSecret = signatureSecret;
            return this;
        }

        public Builder privateKeyContents(byte[] privateKeyContents) {
            this.privateKeyContents = privateKeyContents;
            return this;
        }

        public Builder privateKeyContents(String privateKeyContents) {
            return this.privateKeyContents(privateKeyContents.getBytes());
        }

        public Builder privateKeyPath(Path privateKeyPath) throws NexmoUnableToReadPrivateKeyException {
            try {
                return this.privateKeyContents(Files.readAllBytes(privateKeyPath));
            }
            catch (IOException e) {
                throw new NexmoUnableToReadPrivateKeyException("Unable to read private key at " + privateKeyPath, e);
            }
        }

        public Builder privateKeyPath(String privateKeyPath) throws NexmoUnableToReadPrivateKeyException {
            return this.privateKeyPath(Paths.get(privateKeyPath, new String[0]));
        }

        public NexmoClient build() {
            this.authCollection = this.generateAuthCollection(this.applicationId, this.apiKey, this.apiSecret, this.signatureSecret, this.privateKeyContents);
            return new NexmoClient(this);
        }

        private AuthCollection generateAuthCollection(String applicationId, String key, String secret, String signature, byte[] privateKeyContents) {
            AuthCollection authMethods = new AuthCollection();
            try {
                this.validateAuthParameters(applicationId, key, secret, signature, privateKeyContents);
            }
            catch (IllegalStateException e) {
                throw new NexmoClientCreationException("Failed to generate authentication methods.", e);
            }
            if (key != null && secret != null) {
                authMethods.add(new TokenAuthMethod(key, secret));
            }
            if (key != null && signature != null) {
                authMethods.add(new SignatureAuthMethod(key, signature));
            }
            if (applicationId != null && privateKeyContents != null) {
                authMethods.add(new JWTAuthMethod(applicationId, privateKeyContents));
            }
            return authMethods;
        }

        private void validateAuthParameters(String applicationId, String key, String secret, String signature, byte[] privateKeyContents) {
            if (key != null && secret == null && signature == null) {
                throw new IllegalStateException("You must provide an API secret or signature secret in addition to your API key.");
            }
            if (secret != null && key == null) {
                throw new IllegalStateException("You must provide an API key in addition to your API secret.");
            }
            if (signature != null && key == null) {
                throw new IllegalStateException("You must provide an API key in addition to your signature secret.");
            }
            if (applicationId == null && privateKeyContents != null) {
                throw new IllegalStateException("You must provide an application ID in addition to your private key.");
            }
            if (applicationId != null && privateKeyContents == null) {
                throw new IllegalStateException("You must provide a private key in addition to your application id.");
            }
        }
    }
}

