/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.account;

import com.nexmo.client.HttpWrapper;
import com.nexmo.client.account.CreateSecretMethod;
import com.nexmo.client.account.CreateSecretRequest;
import com.nexmo.client.account.GetSecretMethod;
import com.nexmo.client.account.ListSecretsMethod;
import com.nexmo.client.account.ListSecretsResponse;
import com.nexmo.client.account.RevokeSecretMethod;
import com.nexmo.client.account.SecretRequest;
import com.nexmo.client.account.SecretResponse;

class SecretManagementEndpoint {
    private ListSecretsMethod listSecretsMethod;
    private GetSecretMethod getSecretMethod;
    private CreateSecretMethod createSecretMethod;
    private RevokeSecretMethod revokeSecretMethod;

    SecretManagementEndpoint(HttpWrapper httpWrapper) {
        this.listSecretsMethod = new ListSecretsMethod(httpWrapper);
        this.getSecretMethod = new GetSecretMethod(httpWrapper);
        this.createSecretMethod = new CreateSecretMethod(httpWrapper);
        this.revokeSecretMethod = new RevokeSecretMethod(httpWrapper);
    }

    ListSecretsResponse listSecrets(String apiKey) {
        return (ListSecretsResponse)this.listSecretsMethod.execute(apiKey);
    }

    SecretResponse getSecret(SecretRequest secretRequest) {
        return (SecretResponse)this.getSecretMethod.execute(secretRequest);
    }

    SecretResponse createSecret(CreateSecretRequest createSecretRequest) {
        return (SecretResponse)this.createSecretMethod.execute(createSecretRequest);
    }

    void revokeSecret(SecretRequest secretRequest) {
        this.revokeSecretMethod.execute(secretRequest);
    }
}

