/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.account;

import com.nexmo.client.AbstractMethod;
import com.nexmo.client.HttpWrapper;
import com.nexmo.client.NexmoBadRequestException;
import com.nexmo.client.account.SettingsRequest;
import com.nexmo.client.account.SettingsResponse;
import com.nexmo.client.auth.TokenAuthMethod;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.util.EntityUtils;

class SettingsMethod
extends AbstractMethod<SettingsRequest, SettingsResponse> {
    private static final Class[] ALLOWED_AUTH_METHODS = new Class[]{TokenAuthMethod.class};
    private static final String PATH = "/account/settings";

    SettingsMethod(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(SettingsRequest request) throws UnsupportedEncodingException {
        return RequestBuilder.post((String)(this.httpWrapper.getHttpConfig().getRestBaseUri() + PATH)).addParameter("moCallBackUrl", request.getIncomingSmsUrl()).addParameter("drCallBackUrl", request.getDeliveryReceiptUrl());
    }

    @Override
    public SettingsResponse parseResponse(HttpResponse response) throws IOException {
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new NexmoBadRequestException(EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        return SettingsResponse.fromJson(new BasicResponseHandler().handleResponse(response));
    }
}

