/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.incoming;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nexmo.client.NexmoUnexpectedException;
import com.nexmo.client.incoming.CallDirection;
import com.nexmo.client.incoming.CallStatus;
import java.io.IOException;
import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CallEvent {
    private String conversationUuid;
    private CallDirection direction;
    private String from;
    private CallStatus status;
    private Date timestamp;
    private String to;
    private String uuid;

    @JsonProperty(value="conversation_uuid")
    public String getConversationUuid() {
        return this.conversationUuid;
    }

    public CallDirection getDirection() {
        return this.direction;
    }

    public String getFrom() {
        return this.from;
    }

    public CallStatus getStatus() {
        return this.status;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getTo() {
        return this.to;
    }

    public String getUuid() {
        return this.uuid;
    }

    public static CallEvent fromJson(String json) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return (CallEvent)mapper.readValue(json, CallEvent.class);
        }
        catch (IOException jpe) {
            throw new NexmoUnexpectedException("Failed to produce CallEvent from json.", jpe);
        }
    }
}

