/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.incoming;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nexmo.client.NexmoUnexpectedException;
import com.nexmo.client.incoming.MessageType;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MessageEvent {
    private String msisdn;
    private String to;
    private String messageId;
    private String text;
    private MessageType type;
    private String keyword;
    private Date messageTimestamp;
    private String timestamp;
    private String nonce;
    private Boolean concat;
    private int concatRef;
    private int concatTotal;
    private int concatPart;
    private String data;
    private String udh;

    public String getMsisdn() {
        return this.msisdn;
    }

    public String getTo() {
        return this.to;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getText() {
        return this.text;
    }

    public MessageType getType() {
        return this.type;
    }

    public String getKeyword() {
        return this.keyword;
    }

    @JsonProperty(value="message-timestamp")
    public Date getMessageTimestamp() {
        return this.messageTimestamp;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getNonce() {
        return this.nonce;
    }

    public Boolean getConcat() {
        return this.concat;
    }

    @JsonProperty(value="concat-ref")
    public int getConcatRef() {
        return this.concatRef;
    }

    @JsonProperty(value="concat-total")
    public int getConcatTotal() {
        return this.concatTotal;
    }

    @JsonProperty(value="concat-part")
    public int getConcatPart() {
        return this.concatPart;
    }

    public String getData() {
        return this.data;
    }

    public String getUdh() {
        return this.udh;
    }

    public static MessageEvent fromJson(String json) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            ObjectMapper mapper = new ObjectMapper();
            mapper.setDateFormat((DateFormat)dateFormat);
            return (MessageEvent)mapper.readValue(json, MessageEvent.class);
        }
        catch (IOException jpe) {
            throw new NexmoUnexpectedException("Failed to produce MessageEvent from json.", jpe);
        }
    }
}

