/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.insight;

import com.nexmo.client.AbstractMethod;
import com.nexmo.client.HttpWrapper;
import com.nexmo.client.auth.SignatureAuthMethod;
import com.nexmo.client.auth.TokenAuthMethod;
import com.nexmo.client.insight.BasicInsightRequest;
import com.nexmo.client.insight.BasicInsightResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.BasicResponseHandler;

class BasicInsightEndpoint
extends AbstractMethod<BasicInsightRequest, BasicInsightResponse> {
    private static final Class[] ALLOWED_AUTH_METHODS = new Class[]{SignatureAuthMethod.class, TokenAuthMethod.class};
    private static final String PATH = "/ni/basic/json";

    BasicInsightEndpoint(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(BasicInsightRequest request) throws UnsupportedEncodingException {
        RequestBuilder requestBuilder = RequestBuilder.post((String)(this.httpWrapper.getHttpConfig().getApiBaseUri() + PATH)).addParameter("number", request.getNumber());
        if (request.getCountry() != null) {
            requestBuilder.addParameter("country", request.getCountry());
        }
        return requestBuilder;
    }

    @Override
    public BasicInsightResponse parseResponse(HttpResponse response) throws IOException {
        return BasicInsightResponse.fromJson(new BasicResponseHandler().handleResponse(response));
    }
}

