/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.insight;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

public class RoamingDetails {
    private RoamingStatus status;
    private String roamingCountryCode;
    private String roamingNetworkCode;
    private String roamingNetworkName;

    public RoamingStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="roaming_country_code")
    public String getRoamingCountryCode() {
        return this.roamingCountryCode;
    }

    @JsonProperty(value="roaming_network_code")
    public String getRoamingNetworkCode() {
        return this.roamingNetworkCode;
    }

    @JsonProperty(value="roaming_network_name")
    public String getRoamingNetworkName() {
        return this.roamingNetworkName;
    }

    public static enum RoamingStatus {
        UNKNOWN,
        ROAMING,
        NOT_ROAMING;

        private static final Map<String, RoamingStatus> ROAMING_STATUS_INDEX;

        @JsonCreator
        public static RoamingStatus fromString(String name) {
            RoamingStatus foundRoamingStatus = ROAMING_STATUS_INDEX.get(name.toUpperCase());
            return foundRoamingStatus != null ? foundRoamingStatus : UNKNOWN;
        }

        static {
            ROAMING_STATUS_INDEX = new HashMap<String, RoamingStatus>();
            for (RoamingStatus roamingStatus : RoamingStatus.values()) {
                ROAMING_STATUS_INDEX.put(roamingStatus.name(), roamingStatus);
            }
        }
    }
}

