/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.insight;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nexmo.client.NexmoUnexpectedException;
import com.nexmo.client.insight.BasicInsightResponse;
import com.nexmo.client.insight.CallerIdentity;
import com.nexmo.client.insight.CarrierDetails;
import java.io.IOException;
import java.math.BigDecimal;

@JsonIgnoreProperties(ignoreUnknown=true)
public class StandardInsightResponse
extends BasicInsightResponse {
    private BigDecimal requestPrice;
    private BigDecimal remainingBalance;
    private BigDecimal refundPrice;
    private CarrierDetails originalCarrier;
    private CarrierDetails currentCarrier;
    private CallerIdentity callerIdentity;

    public static StandardInsightResponse fromJson(String json) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return (StandardInsightResponse)mapper.readValue(json, StandardInsightResponse.class);
        }
        catch (IOException jpe) {
            throw new NexmoUnexpectedException("Failed to produce StandardInsightResponse from json.", jpe);
        }
    }

    @JsonProperty(value="request_price")
    public BigDecimal getRequestPrice() {
        return this.requestPrice;
    }

    @JsonProperty(value="remaining_balance")
    public BigDecimal getRemainingBalance() {
        return this.remainingBalance;
    }

    @JsonProperty(value="original_carrier")
    public CarrierDetails getOriginalCarrier() {
        return this.originalCarrier;
    }

    @JsonProperty(value="current_carrier")
    public CarrierDetails getCurrentCarrier() {
        return this.currentCarrier;
    }

    @JsonProperty(value="caller_identity")
    public CallerIdentity getCallerIdentity() {
        return this.callerIdentity;
    }

    @JsonProperty(value="refund_price")
    public BigDecimal getRefundPrice() {
        return this.refundPrice;
    }
}

