/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.sns;

import com.nexmo.client.AbstractMethod;
import com.nexmo.client.HttpWrapper;
import com.nexmo.client.NexmoResponseParseException;
import com.nexmo.client.auth.SignatureAuthMethod;
import com.nexmo.client.auth.TokenAuthMethod;
import com.nexmo.client.legacyutils.XmlParser;
import com.nexmo.client.legacyutils.XmlUtil;
import com.nexmo.client.sns.SnsClient;
import com.nexmo.client.sns.request.SnsRequest;
import com.nexmo.client.sns.response.SnsPublishResponse;
import com.nexmo.client.sns.response.SnsResponse;
import com.nexmo.client.sns.response.SnsSubscribeResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.BasicResponseHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class SnsEndpoint
extends AbstractMethod<SnsRequest, SnsResponse> {
    private static final Log log = LogFactory.getLog(SnsClient.class);
    private static final Class[] ALLOWED_AUTH_METHODS = new Class[]{SignatureAuthMethod.class, TokenAuthMethod.class};
    private static final String PATH = "/sns/xml";
    private XmlParser xmlParser = new XmlParser();

    SnsEndpoint(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(SnsRequest snsRequest) throws UnsupportedEncodingException {
        RequestBuilder requestBuilder = RequestBuilder.post((String)(this.httpWrapper.getHttpConfig().getSnsBaseUri() + PATH)).addParameter("cmd", snsRequest.getCommand());
        for (Map.Entry<String, String> entry : snsRequest.getQueryParameters().entrySet()) {
            requestBuilder.addParameter(entry.getKey(), entry.getValue());
        }
        return requestBuilder;
    }

    @Override
    public SnsResponse parseResponse(HttpResponse response) throws IOException {
        return this.parseSubmitResponse(new BasicResponseHandler().handleResponse(response));
    }

    protected SnsResponse parseSubmitResponse(String response) {
        Document doc = this.xmlParser.parseXml(response);
        String command = null;
        int resultCode = -1;
        String resultMessage = null;
        String transactionId = null;
        String subscriberArn = null;
        NodeList replies = doc.getElementsByTagName("nexmo-sns");
        Node reply = replies.item(0);
        NodeList nodes = reply.getChildNodes();
        for (int i2 = 0; i2 < nodes.getLength(); ++i2) {
            Node node = nodes.item(i2);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equals("command")) {
                command = XmlUtil.stringValue(node);
                continue;
            }
            if (node.getNodeName().equals("resultCode")) {
                try {
                    resultCode = XmlUtil.intValue(node);
                }
                catch (Exception e) {
                    log.error((Object)("xml parser .. invalid value in <resultCode> node [ " + XmlUtil.stringValue(node) + " ] "));
                    resultCode = 2;
                }
                continue;
            }
            if (node.getNodeName().equals("resultMessage")) {
                resultMessage = XmlUtil.stringValue(node);
                continue;
            }
            if (node.getNodeName().equals("transactionId")) {
                transactionId = XmlUtil.stringValue(node);
                continue;
            }
            if (node.getNodeName().equals("subscriberArn")) {
                subscriberArn = XmlUtil.stringValue(node);
                continue;
            }
            log.error((Object)("xml parser .. unknown node found in nexmo-sns [ " + node.getNodeName() + " ] "));
        }
        if (resultCode == -1) {
            throw new NexmoResponseParseException("Xml Parser - did not find a <resultCode> node");
        }
        if ("publish".equals(command)) {
            return new SnsPublishResponse(resultCode, resultMessage, transactionId);
        }
        if ("subscribe".equals(command)) {
            return new SnsSubscribeResponse(resultCode, resultMessage, subscriberArn);
        }
        throw new NexmoResponseParseException("Unknown command value: " + command);
    }
}

