/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.voice;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nexmo.client.NexmoUnexpectedException;
import com.nexmo.client.voice.Endpoint;
import com.nexmo.client.voice.MachineDetection;
import com.nexmo.client.voice.PhoneEndpoint;
import com.nexmo.client.voice.ncco.Ncco;
import java.io.IOException;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"_links"})
public class Call {
    private Endpoint[] to;
    private Endpoint from;
    private String answerUrl;
    private String answerMethod = "GET";
    private String eventUrl = null;
    private String eventMethod = null;
    private MachineDetection machineDetection = null;
    private Integer lengthTimer = null;
    private Integer ringingTimer = null;
    private Ncco ncco;

    public Call() {
    }

    public Call(String to, String from, String answerUrl) {
        this((Endpoint)new PhoneEndpoint(to), (Endpoint)new PhoneEndpoint(from), answerUrl);
    }

    public Call(Endpoint to, Endpoint from, String answerUrl) {
        this(new Endpoint[]{to}, from, answerUrl);
    }

    public Call(Endpoint[] to, Endpoint from, String answerUrl) {
        this.to = to;
        this.from = from;
        this.answerUrl = answerUrl;
    }

    public Call(String to, String from, Ncco ncco) {
        this((Endpoint)new PhoneEndpoint(to), (Endpoint)new PhoneEndpoint(from), ncco);
    }

    public Call(Endpoint to, Endpoint from, Ncco ncco) {
        this(new Endpoint[]{to}, from, ncco);
    }

    public Call(Endpoint[] to, Endpoint from, Ncco ncco) {
        this.to = to;
        this.from = from;
        this.ncco = ncco;
    }

    public Endpoint[] getTo() {
        return this.to;
    }

    public void setTo(Endpoint[] to) {
        this.to = to;
    }

    public Endpoint getFrom() {
        return this.from;
    }

    public void setFrom(Endpoint from) {
        this.from = from;
    }

    @JsonProperty(value="answer_url")
    public String[] getAnswerUrl() {
        String[] stringArray;
        if (this.answerUrl != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.answerUrl;
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    public void setAnswerUrl(String answerUrl) {
        this.answerUrl = answerUrl;
    }

    @JsonProperty(value="answer_method")
    public String getAnswerMethod() {
        return this.answerUrl != null ? this.answerMethod : null;
    }

    public void setAnswerMethod(String answerMethod) {
        this.answerMethod = answerMethod;
    }

    @JsonProperty(value="event_url")
    public String[] getEventUrl() {
        if (this.eventUrl == null) {
            return null;
        }
        return new String[]{this.eventUrl};
    }

    public void setEventUrl(String eventUrl) {
        this.eventUrl = eventUrl;
    }

    @JsonProperty(value="event_method")
    public String getEventMethod() {
        return this.eventMethod;
    }

    public void setEventMethod(String eventMethod) {
        this.eventMethod = eventMethod;
    }

    @JsonProperty(value="machine_detection")
    public MachineDetection getMachineDetection() {
        return this.machineDetection;
    }

    public void setMachineDetection(MachineDetection machineDetection) {
        this.machineDetection = machineDetection;
    }

    @JsonProperty(value="length_timer")
    public Integer getLengthTimer() {
        return this.lengthTimer;
    }

    public void setLengthTimer(Integer lengthTimer) {
        this.lengthTimer = lengthTimer;
    }

    @JsonProperty(value="ringing_timer")
    public Integer getRingingTimer() {
        return this.ringingTimer;
    }

    public void setRingingTimer(Integer ringingTimer) {
        this.ringingTimer = ringingTimer;
    }

    @JsonProperty(value="ncco")
    public Ncco getNcco() {
        return this.ncco;
    }

    public String toJson() {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException jpe) {
            throw new NexmoUnexpectedException("Failed to produce json from Call object.", jpe);
        }
    }

    public static Call fromJson(String json) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return (Call)mapper.readValue(json, Call.class);
        }
        catch (IOException jpe) {
            throw new NexmoUnexpectedException("Failed to produce json from Call object.", jpe);
        }
    }
}

