/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.jwk.source;

import com.nimbusds.jose.RemoteKeySourceException;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jose.util.DefaultResourceRetriever;
import com.nimbusds.jose.util.Resource;
import com.nimbusds.jose.util.ResourceRetriever;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class RemoteJWKSet<C extends SecurityContext>
implements JWKSource<C> {
    public static final int DEFAULT_HTTP_CONNECT_TIMEOUT = 250;
    public static final int DEFAULT_HTTP_READ_TIMEOUT = 250;
    public static final int DEFAULT_HTTP_SIZE_LIMIT = 51200;
    private final URL jwkSetURL;
    private final AtomicReference<JWKSet> cachedJWKSet = new AtomicReference();
    private final ResourceRetriever jwkSetRetriever;

    public RemoteJWKSet(URL jwkSetURL) {
        this(jwkSetURL, null);
    }

    public RemoteJWKSet(URL jwkSetURL, ResourceRetriever resourceRetriever) {
        if (jwkSetURL == null) {
            throw new IllegalArgumentException("The JWK set URL must not be null");
        }
        this.jwkSetURL = jwkSetURL;
        this.jwkSetRetriever = resourceRetriever != null ? resourceRetriever : new DefaultResourceRetriever(250, 250, 51200);
    }

    private JWKSet updateJWKSetFromURL() throws RemoteKeySourceException {
        JWKSet jwkSet;
        Resource res;
        try {
            res = this.jwkSetRetriever.retrieveResource(this.jwkSetURL);
        }
        catch (IOException e) {
            throw new RemoteKeySourceException("Couldn't retrieve remote JWK set: " + e.getMessage(), e);
        }
        try {
            jwkSet = JWKSet.parse(res.getContent());
        }
        catch (ParseException e) {
            throw new RemoteKeySourceException("Couldn't parse remote JWK set: " + e.getMessage(), e);
        }
        this.cachedJWKSet.set(jwkSet);
        return jwkSet;
    }

    public URL getJWKSetURL() {
        return this.jwkSetURL;
    }

    public ResourceRetriever getResourceRetriever() {
        return this.jwkSetRetriever;
    }

    public JWKSet getCachedJWKSet() {
        return this.cachedJWKSet.get();
    }

    protected static String getFirstSpecifiedKeyID(JWKMatcher jwkMatcher) {
        Set<String> keyIDs = jwkMatcher.getKeyIDs();
        if (keyIDs == null || keyIDs.isEmpty()) {
            return null;
        }
        for (String id : keyIDs) {
            if (id == null) continue;
            return id;
        }
        return null;
    }

    @Override
    public List<JWK> get(JWKSelector jwkSelector, C context) throws RemoteKeySourceException {
        List<JWK> matches;
        JWKSet jwkSet = this.cachedJWKSet.get();
        if (jwkSet == null) {
            jwkSet = this.updateJWKSetFromURL();
        }
        if (!(matches = jwkSelector.select(jwkSet)).isEmpty()) {
            return matches;
        }
        String soughtKeyID = RemoteJWKSet.getFirstSpecifiedKeyID(jwkSelector.getMatcher());
        if (soughtKeyID == null) {
            return Collections.emptyList();
        }
        if (jwkSet.getKeyByKeyId(soughtKeyID) != null) {
            return Collections.emptyList();
        }
        jwkSet = this.updateJWKSetFromURL();
        if (jwkSet == null) {
            return Collections.emptyList();
        }
        return jwkSelector.select(jwkSet);
    }
}

