/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;

public class Filters {
    private static ObjectMapper OBJECT_MAPPER = new JacksonJaxbJsonProvider().locateMapper(Map.class, MediaType.APPLICATION_JSON_TYPE);
    private Map<String, List<String>> filters = new HashMap<String, List<String>>();

    public Filters withFilter(String key, String ... value) {
        this.filters.put(key, Arrays.asList(value));
        return this;
    }

    public List<String> getFilter(String key) {
        return this.filters.get(key);
    }

    public Filters withImages(String ... image) {
        this.withFilter("image", image);
        return this;
    }

    public List<String> getImage() {
        return this.getFilter("image");
    }

    public Filters withContainers(String ... container) {
        this.withFilter("container", container);
        return this;
    }

    public List<String> getContainer() {
        return this.getFilter("container");
    }

    public Filters withLabels(String ... labels) {
        this.withFilter("label", labels);
        return this;
    }

    public Filters withLabels(Map<String, String> labels) {
        this.withFilter("label", Filters.labelsMapToList(labels).toArray(new String[labels.size()]));
        return this;
    }

    private static List<String> labelsMapToList(Map<String, String> labels) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, String> entry : labels.entrySet()) {
            String rest = entry.getValue() != null & !entry.getValue().isEmpty() ? "=" + entry.getValue() : "";
            String label = entry.getKey() + rest;
            result.add(label);
        }
        return result;
    }

    public String toString() {
        try {
            return OBJECT_MAPPER.writeValueAsString(this.filters);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

