/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Binds;
import com.github.dockerjava.api.model.Capability;
import com.github.dockerjava.api.model.Device;
import com.github.dockerjava.api.model.Link;
import com.github.dockerjava.api.model.Links;
import com.github.dockerjava.api.model.LogConfig;
import com.github.dockerjava.api.model.LxcConf;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.RestartPolicy;
import com.github.dockerjava.api.model.Ulimit;
import com.github.dockerjava.api.model.VolumesFrom;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonIgnoreProperties(ignoreUnknown=true)
public class HostConfig {
    @JsonProperty(value="Binds")
    private Binds binds;
    @JsonProperty(value="Links")
    private Links links;
    @JsonProperty(value="LxcConf")
    private LxcConf[] lxcConf;
    @JsonProperty(value="LogConfig")
    private LogConfig logConfig;
    @JsonProperty(value="PortBindings")
    private Ports portBindings;
    @JsonProperty(value="PublishAllPorts")
    private boolean publishAllPorts;
    @JsonProperty(value="Privileged")
    private boolean privileged;
    @JsonProperty(value="ReadonlyRootfs")
    private boolean readonlyRootfs;
    @JsonProperty(value="Dns")
    private String[] dns;
    @JsonProperty(value="DnsSearch")
    private String[] dnsSearch;
    @JsonProperty(value="VolumesFrom")
    private VolumesFrom[] volumesFrom;
    @JsonProperty(value="ContainerIDFile")
    private String containerIDFile;
    @JsonProperty(value="CapAdd")
    private Capability[] capAdd;
    @JsonProperty(value="CapDrop")
    private Capability[] capDrop;
    @JsonProperty(value="RestartPolicy")
    private RestartPolicy restartPolicy;
    @JsonProperty(value="NetworkMode")
    private String networkMode;
    @JsonProperty(value="Devices")
    private Device[] devices;
    @JsonProperty(value="ExtraHosts")
    private String[] extraHosts;
    @JsonProperty(value="Ulimits")
    private Ulimit[] ulimits;
    @JsonProperty(value="Memory")
    private long memoryLimit = 0L;
    @JsonProperty(value="MemorySwap")
    private long memorySwap = 0L;
    @JsonProperty(value="CpuShares")
    private int cpuShares = 0;

    public HostConfig() {
    }

    public HostConfig(Bind[] binds, Link[] links, LxcConf[] lxcConf, LogConfig logConfig, Ports portBindings, boolean publishAllPorts, boolean privileged, boolean readonlyRootfs, String[] dns, String[] dnsSearch, VolumesFrom[] volumesFrom, String containerIDFile, Capability[] capAdd, Capability[] capDrop, RestartPolicy restartPolicy, String networkMode, Device[] devices, String[] extraHosts, Ulimit[] ulimits) {
        this.binds = new Binds(binds);
        this.links = new Links(links);
        this.lxcConf = lxcConf;
        this.logConfig = logConfig;
        this.portBindings = portBindings;
        this.publishAllPorts = publishAllPorts;
        this.privileged = privileged;
        this.readonlyRootfs = readonlyRootfs;
        this.dns = dns;
        this.dnsSearch = dnsSearch;
        this.volumesFrom = volumesFrom;
        this.containerIDFile = containerIDFile;
        this.capAdd = capAdd;
        this.capDrop = capDrop;
        this.restartPolicy = restartPolicy;
        this.networkMode = networkMode;
        this.devices = devices;
        this.extraHosts = extraHosts;
        this.ulimits = ulimits;
    }

    @JsonIgnore
    public Bind[] getBinds() {
        return this.binds == null ? new Bind[]{} : this.binds.getBinds();
    }

    public LxcConf[] getLxcConf() {
        return this.lxcConf;
    }

    @JsonIgnore
    public LogConfig getLogConfig() {
        return this.logConfig == null ? new LogConfig() : this.logConfig;
    }

    public Ports getPortBindings() {
        return this.portBindings;
    }

    public boolean isPublishAllPorts() {
        return this.publishAllPorts;
    }

    public boolean isPrivileged() {
        return this.privileged;
    }

    public boolean isReadonlyRootfs() {
        return this.readonlyRootfs;
    }

    public String[] getDns() {
        return this.dns;
    }

    public VolumesFrom[] getVolumesFrom() {
        return this.volumesFrom;
    }

    public String getContainerIDFile() {
        return this.containerIDFile;
    }

    public String[] getDnsSearch() {
        return this.dnsSearch;
    }

    @JsonIgnore
    public Link[] getLinks() {
        return this.links == null ? new Link[]{} : this.links.getLinks();
    }

    public String getNetworkMode() {
        return this.networkMode;
    }

    public Device[] getDevices() {
        return this.devices;
    }

    public String[] getExtraHosts() {
        return this.extraHosts;
    }

    public RestartPolicy getRestartPolicy() {
        return this.restartPolicy;
    }

    public Capability[] getCapAdd() {
        return this.capAdd;
    }

    public Capability[] getCapDrop() {
        return this.capDrop;
    }

    public Ulimit[] getUlimits() {
        return this.ulimits;
    }

    public long getMemoryLimit() {
        return this.memoryLimit;
    }

    public long getMemorySwap() {
        return this.memorySwap;
    }

    public int getCpuShares() {
        return this.cpuShares;
    }

    @JsonIgnore
    public void setBinds(Bind ... binds) {
        this.binds = new Binds(binds);
    }

    @JsonIgnore
    public void setLinks(Link ... links) {
        this.links = new Links(links);
    }

    public void setLxcConf(LxcConf[] lxcConf) {
        this.lxcConf = lxcConf;
    }

    @JsonIgnore
    public void setLogConfig(LogConfig logConfig) {
        this.logConfig = logConfig;
    }

    public void setPortBindings(Ports portBindings) {
        this.portBindings = portBindings;
    }

    public void setPublishAllPorts(boolean publishAllPorts) {
        this.publishAllPorts = publishAllPorts;
    }

    public void setPrivileged(boolean privileged) {
        this.privileged = privileged;
    }

    public void setReadonlyRootfs(boolean readonlyRootfs) {
        this.readonlyRootfs = readonlyRootfs;
    }

    public void setDns(String[] dns) {
        this.dns = dns;
    }

    public void setDnsSearch(String[] dnsSearch) {
        this.dnsSearch = dnsSearch;
    }

    public void setVolumesFrom(VolumesFrom[] volumesFrom) {
        this.volumesFrom = volumesFrom;
    }

    public void setContainerIDFile(String containerIDFile) {
        this.containerIDFile = containerIDFile;
    }

    public void setCapAdd(Capability[] capAdd) {
        this.capAdd = capAdd;
    }

    public void setCapDrop(Capability[] capDrop) {
        this.capDrop = capDrop;
    }

    public void setRestartPolicy(RestartPolicy restartPolicy) {
        this.restartPolicy = restartPolicy;
    }

    public void setNetworkMode(String networkMode) {
        this.networkMode = networkMode;
    }

    public void setDevices(Device[] devices) {
        this.devices = devices;
    }

    public void setExtraHosts(String[] extraHosts) {
        this.extraHosts = extraHosts;
    }

    public void setUlimits(Ulimit[] ulimits) {
        this.ulimits = ulimits;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

