/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.command.ListContainersCmd;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.Filters;
import com.github.dockerjava.core.command.AbstrDockerCmd;
import java.util.List;
import shaded.com.google.common.base.Preconditions;

public class ListContainersCmdImpl
extends AbstrDockerCmd<ListContainersCmd, List<Container>>
implements ListContainersCmd {
    private int limit = -1;
    private boolean showSize;
    private boolean showAll = false;
    private String sinceId;
    private String beforeId;
    private Filters filters;

    public ListContainersCmdImpl(ListContainersCmd.Exec exec) {
        super(exec);
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public boolean hasShowSizeEnabled() {
        return this.showSize;
    }

    @Override
    public boolean hasShowAllEnabled() {
        return this.showAll;
    }

    @Override
    public String getSinceId() {
        return this.sinceId;
    }

    @Override
    public String getBeforeId() {
        return this.beforeId;
    }

    @Override
    public Filters getFilters() {
        return this.filters;
    }

    @Override
    public ListContainersCmd withShowAll(boolean showAll) {
        this.showAll = showAll;
        return this;
    }

    @Override
    public ListContainersCmd withShowSize(boolean showSize) {
        this.showSize = showSize;
        return this;
    }

    @Override
    public ListContainersCmd withLimit(int limit) {
        Preconditions.checkArgument(limit > 0, "limit must be greater 0");
        this.limit = limit;
        return this;
    }

    @Override
    public ListContainersCmd withSince(String since) {
        Preconditions.checkNotNull(since, "since was not specified");
        this.sinceId = since;
        return this;
    }

    @Override
    public ListContainersCmd withBefore(String before) {
        Preconditions.checkNotNull(before, "before was not specified");
        this.beforeId = before;
        return this;
    }

    @Override
    public ListContainersCmd withFilters(Filters filters) {
        Preconditions.checkNotNull(filters, "filters was not specified");
        this.filters = filters;
        return this;
    }

    public String toString() {
        return "ps " + (this.showAll ? "--all=true" : "") + (this.showSize ? "--size=true" : "") + (this.sinceId != null ? " --since " + this.sinceId : "") + (this.beforeId != null ? " --before " + this.beforeId : "") + (this.limit != -1 ? "-n " + this.limit : "") + (this.filters != null ? " --filters " + this.filters : "");
    }
}

