/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.command.LogContainerCmd;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.core.command.AbstrAsyncDockerCmd;
import shaded.com.google.common.base.Preconditions;

public class LogContainerCmdImpl
extends AbstrAsyncDockerCmd<LogContainerCmd, Frame>
implements LogContainerCmd {
    private String containerId;
    private int tail = -1;
    private boolean followStream;
    private boolean timestamps;
    private boolean stdout;
    private boolean stderr;
    private int since = 0;

    public LogContainerCmdImpl(LogContainerCmd.Exec exec, String containerId) {
        super(exec);
        this.withContainerId(containerId);
    }

    @Override
    public String getContainerId() {
        return this.containerId;
    }

    @Override
    public int getTail() {
        return this.tail;
    }

    @Override
    public boolean hasFollowStreamEnabled() {
        return this.followStream;
    }

    @Override
    public boolean hasTimestampsEnabled() {
        return this.timestamps;
    }

    @Override
    public boolean hasStdoutEnabled() {
        return this.stdout;
    }

    @Override
    public boolean hasStderrEnabled() {
        return this.stderr;
    }

    @Override
    public int getSince() {
        return this.since;
    }

    @Override
    public LogContainerCmd withContainerId(String containerId) {
        Preconditions.checkNotNull(containerId, "containerId was not specified");
        this.containerId = containerId;
        return this;
    }

    @Override
    public LogContainerCmd withFollowStream() {
        return this.withFollowStream(true);
    }

    @Override
    public LogContainerCmd withFollowStream(boolean followStream) {
        this.followStream = followStream;
        return this;
    }

    @Override
    public LogContainerCmd withTimestamps() {
        return this.withTimestamps(true);
    }

    @Override
    public LogContainerCmd withTimestamps(boolean timestamps) {
        this.timestamps = timestamps;
        return this;
    }

    @Override
    public LogContainerCmd withStdOut() {
        return this.withStdOut(true);
    }

    @Override
    public LogContainerCmd withStdOut(boolean stdout) {
        this.stdout = stdout;
        return this;
    }

    @Override
    public LogContainerCmd withStdErr() {
        return this.withStdErr(true);
    }

    @Override
    public LogContainerCmd withStdErr(boolean stderr) {
        this.stderr = stderr;
        return this;
    }

    @Override
    public LogContainerCmd withTailAll() {
        this.tail = -1;
        return this;
    }

    @Override
    public LogContainerCmd withTail(int tail) {
        this.tail = tail;
        return this;
    }

    @Override
    public LogContainerCmd withSince(int since) {
        this.since = since;
        return this;
    }

    public String toString() {
        return "logs " + (this.followStream ? "--follow=true" : "") + (this.timestamps ? "--timestamps=true" : "") + (this.since > 0 ? "--since=" + this.since : "") + this.containerId;
    }
}

