/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.NotFoundException;
import com.github.dockerjava.api.NotModifiedException;
import com.github.dockerjava.api.command.StopContainerCmd;
import com.github.dockerjava.core.command.AbstrDockerCmd;
import shaded.com.google.common.base.Preconditions;

public class StopContainerCmdImpl
extends AbstrDockerCmd<StopContainerCmd, Void>
implements StopContainerCmd {
    private String containerId;
    private int timeout = 10;

    public StopContainerCmdImpl(StopContainerCmd.Exec exec, String containerId) {
        super(exec);
        this.withContainerId(containerId);
    }

    @Override
    public String getContainerId() {
        return this.containerId;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public StopContainerCmd withContainerId(String containerId) {
        Preconditions.checkNotNull(containerId, "containerId was not specified");
        this.containerId = containerId;
        return this;
    }

    @Override
    public StopContainerCmd withTimeout(int timeout) {
        Preconditions.checkArgument(timeout >= 0, "timeout must be greater or equal 0");
        this.timeout = timeout;
        return this;
    }

    public String toString() {
        return "stop " + ("--time=" + this.timeout + " ") + this.containerId;
    }

    @Override
    public Void exec() throws NotFoundException, NotModifiedException {
        return (Void)super.exec();
    }
}

