/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.jaxrs;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.model.AuthConfigurations;
import com.github.dockerjava.api.model.BuildResponseItem;
import com.github.dockerjava.core.async.JsonStreamProcessor;
import com.github.dockerjava.jaxrs.AbstrAsyncDockerCmdExec;
import com.github.dockerjava.jaxrs.async.AbstractCallbackNotifier;
import com.github.dockerjava.jaxrs.async.POSTCallbackNotifier;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildImageCmdExec
extends AbstrAsyncDockerCmdExec<BuildImageCmd, BuildResponseItem>
implements BuildImageCmd.Exec {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildImageCmdExec.class);

    public BuildImageCmdExec(WebTarget baseResource) {
        super(baseResource);
    }

    private Invocation.Builder resourceWithOptionalAuthConfig(BuildImageCmd command, Invocation.Builder request) {
        AuthConfigurations authConfigs = command.getBuildAuthConfigs();
        if (authConfigs != null) {
            request = request.header("X-Registry-Config", (Object)this.registryConfigs(authConfigs));
        }
        return request;
    }

    @Override
    protected AbstractCallbackNotifier<BuildResponseItem> callbackNotifier(BuildImageCmd command, ResultCallback<BuildResponseItem> resultCallback) {
        WebTarget webTarget = this.getBaseResource().path("/build");
        String dockerFilePath = command.getPathToDockerfile();
        if (dockerFilePath != null && command.getRemote() == null && !"Dockerfile".equals(dockerFilePath)) {
            webTarget = webTarget.queryParam("dockerfile", new Object[]{dockerFilePath});
        }
        if (command.getTag() != null) {
            webTarget = webTarget.queryParam("t", new Object[]{command.getTag()});
        }
        if (command.getRemote() != null) {
            webTarget = webTarget.queryParam("remote", new Object[]{command.getRemote().toString()});
        }
        if (command.isQuiet()) {
            webTarget = webTarget.queryParam("q", new Object[]{"true"});
        }
        if (command.hasNoCacheEnabled()) {
            webTarget = webTarget.queryParam("nocache", new Object[]{"true"});
        }
        if (command.hasPullEnabled()) {
            webTarget = webTarget.queryParam("pull", new Object[]{"true"});
        }
        if (!command.hasRemoveEnabled()) {
            webTarget = webTarget.queryParam("rm", new Object[]{"false"});
        }
        if (command.isForcerm()) {
            webTarget = webTarget.queryParam("forcerm", new Object[]{"true"});
        }
        if (command.getMemory() != null) {
            webTarget = webTarget.queryParam("memory", new Object[]{command.getMemory()});
        }
        if (command.getMemswap() != null) {
            webTarget = webTarget.queryParam("memswap", new Object[]{command.getMemswap()});
        }
        if (command.getCpushares() != null) {
            webTarget = webTarget.queryParam("cpushares", new Object[]{command.getCpushares()});
        }
        if (command.getCpusetcpus() != null) {
            webTarget = webTarget.queryParam("cpusetcpus", new Object[]{command.getCpusetcpus()});
        }
        webTarget.property("jersey.config.client.request.entity.processing", (Object)RequestEntityProcessing.CHUNKED);
        webTarget.property("jersey.config.client.chunkedEncodingSize", (Object)0x100000);
        LOGGER.trace("POST: {}", (Object)webTarget);
        return new POSTCallbackNotifier<BuildResponseItem>(new JsonStreamProcessor<BuildResponseItem>(BuildResponseItem.class), resultCallback, this.resourceWithOptionalAuthConfig(command, webTarget.request()).accept(new String[]{"text/plain"}), Entity.entity((Object)command.getTarInputStream(), (String)"application/tar"));
    }
}

