/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.jaxrs.connector;

import com.github.dockerjava.jaxrs.connector.ApacheConnector;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;
import org.glassfish.jersey.apache.connector.LocalizationMessages;
import org.glassfish.jersey.client.Initializable;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import shaded.org.apache.http.client.HttpClient;

public class ApacheConnectorProvider
implements ConnectorProvider {
    @Override
    public Connector getConnector(Client client, Configuration runtimeConfig) {
        return new ApacheConnector(runtimeConfig);
    }

    public static HttpClient getHttpClient(Configurable<?> component) {
        if (!(component instanceof Initializable)) {
            throw new IllegalArgumentException(LocalizationMessages.INVALID_CONFIGURABLE_COMPONENT_TYPE(component.getClass().getName()));
        }
        Initializable initializable = (Initializable)component;
        Connector connector = initializable.getConfiguration().getConnector();
        if (connector == null) {
            initializable.preInitialize();
            connector = initializable.getConfiguration().getConnector();
        }
        if (connector instanceof ApacheConnector) {
            return ((ApacheConnector)connector).getHttpClient();
        }
        throw new IllegalArgumentException(LocalizationMessages.EXPECTED_CONNECTOR_PROVIDER_NOT_USED());
    }
}

