/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.http.impl.conn;

import java.net.InetAddress;
import shaded.org.apache.http.HttpException;
import shaded.org.apache.http.HttpHost;
import shaded.org.apache.http.HttpRequest;
import shaded.org.apache.http.annotation.Immutable;
import shaded.org.apache.http.client.config.RequestConfig;
import shaded.org.apache.http.client.protocol.HttpClientContext;
import shaded.org.apache.http.conn.SchemePortResolver;
import shaded.org.apache.http.conn.UnsupportedSchemeException;
import shaded.org.apache.http.conn.routing.HttpRoute;
import shaded.org.apache.http.conn.routing.HttpRoutePlanner;
import shaded.org.apache.http.impl.conn.DefaultSchemePortResolver;
import shaded.org.apache.http.protocol.HttpContext;
import shaded.org.apache.http.util.Args;

@Immutable
public class DefaultRoutePlanner
implements HttpRoutePlanner {
    private final SchemePortResolver schemePortResolver;

    public DefaultRoutePlanner(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
    }

    public HttpRoute determineRoute(HttpHost host, HttpRequest request, HttpContext context) throws HttpException {
        HttpHost target;
        Args.notNull(host, "Target host");
        Args.notNull(request, "Request");
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RequestConfig config = clientContext.getRequestConfig();
        InetAddress local = config.getLocalAddress();
        HttpHost proxy = config.getProxy();
        if (proxy == null) {
            proxy = this.determineProxy(host, request, context);
        }
        if (host.getPort() <= 0) {
            try {
                target = new HttpHost(host.getHostName(), this.schemePortResolver.resolve(host), host.getSchemeName());
            }
            catch (UnsupportedSchemeException ex) {
                throw new HttpException(ex.getMessage());
            }
        } else {
            target = host;
        }
        boolean secure = target.getSchemeName().equalsIgnoreCase("https");
        if (proxy == null) {
            return new HttpRoute(target, local, secure);
        }
        return new HttpRoute(target, local, proxy, secure);
    }

    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        return null;
    }
}

